/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.asciidoctor_idgen;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import ru.curs.asciidoctor_idgen.Converter;
import ru.curs.asciidoctor_idgen.ExtendedBlock;
import ru.curs.asciidoctor_idgen.Extender;
import ru.curs.asciidoctor_idgen.Lurker;
import ru.curs.asciidoctor_idgen.OutputLog;

@SpringBootApplication
public class Main {
    public static void main(String[] args2) throws ParseException, IOException {
        if (args2.length == 0) {
            SpringApplication.run(Main.class, args2);
        } else {
            Options options2 = new Options();
            options2.addRequiredOption("i", "input", true, "input file to parse");
            options2.addRequiredOption("o", "output", true, "output file to write");
            options2.addRequiredOption("j", "json", true, "input file to parse");
            options2.addOption("ohtml", "output-html", false, "Convert output file to html");
            DefaultParser parser = new DefaultParser();
            CommandLine cmdLine = parser.parse(options2, args2);
            String adocFilePath = cmdLine.getOptionValue("input");
            String outFilePath = cmdLine.getOptionValue("output");
            String jsonFilePath = cmdLine.getOptionValue("json");
            Boolean outputHtml = cmdLine.hasOption("ohtml");
            Main.enrich(adocFilePath, outFilePath, jsonFilePath, outputHtml);
        }
    }

    public static OutputLog enrich(String adocFilePath, String outFilePath, String jsonFilePath, @Nullable Boolean outputHtml) throws IOException {
        OutputLog outputLog = new OutputLog();
        Lurker lurker = new Lurker(adocFilePath);
        ArrayList<ExtendedBlock> allBlocks = lurker.lurk();
        System.out.printf("Parsed successfully. All blocks: %d", allBlocks.size());
        System.out.println();
        outputLog.add("INFO", String.format("Parsed successfully. All blocks: %d", allBlocks.size()));
        Extender extender = new Extender(adocFilePath, outFilePath, jsonFilePath, allBlocks);
        extender.extend();
        System.out.println("Identified successfully.");
        outputLog.add("INFO", "Identified successfully.");
        if (outputHtml.booleanValue()) {
            Converter converter = new Converter(outFilePath);
            outputLog.add(converter.convert());
            outputLog.add("INFO", "Converted successfully.");
            System.out.println("Converted successfully.");
        }
        return outputLog;
    }
}

