/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.asciidoctor_idgen;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.DescriptionListEntry;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.jruby.ast.impl.BlockImpl;
import org.asciidoctor.jruby.ast.impl.DescriptionListImpl;
import org.asciidoctor.jruby.ast.impl.ListImpl;
import org.asciidoctor.jruby.ast.impl.TableImpl;
import ru.curs.asciidoctor_idgen.DefaultValueHandler;
import ru.curs.asciidoctor_idgen.ExtendedBlock;
import ru.curs.asciidoctor_idgen.IdGenerator;

class Lurker {
    private ArrayList<ExtendedBlock> allBlocks = new ArrayList();
    private String path;

    Lurker(String path2) {
        this.path = path2;
    }

    private void touch(StructuralNode block, Boolean isEmbeddedDoc) {
        if (!block.getContext().equals("document") && !block.getContext().equals("preamble")) {
            this.addBlock(block, isEmbeddedDoc);
        }
        if (block.getBlocks() != null) {
            for (StructuralNode abstractBlock : block.getBlocks()) {
                this.touch(abstractBlock, isEmbeddedDoc);
            }
        }
    }

    private void addBlock(StructuralNode block, Boolean isEmbeddedDoc) {
        ExtendedBlock extendedBlock = new ExtendedBlock();
        extendedBlock.context = block.getContext();
        extendedBlock.id = block.getId();
        this.identify(extendedBlock);
        extendedBlock.isEmbeddedDoc = isEmbeddedDoc;
        Object style = block.getAttributes().get("style");
        extendedBlock.style = DefaultValueHandler.getValueOrDefault(style == null ? null : style.toString(), "");
        if (block.getSourceLocation() != null) {
            extendedBlock.sourceLine = block.getSourceLocation().getLineNumber();
        }
        switch (extendedBlock.context) {
            case "image": {
                extendedBlock.target = (String)block.getAttributes().get("target");
                extendedBlock.title = block.getTitle();
                break;
            }
            case "paragraph": {
                extendedBlock.sourceText = ((BlockImpl)block).getSource();
                extendedBlock.htmlText = StringEscapeUtils.escapeHtml4((String)block.getContent());
                break;
            }
            case "section": {
                extendedBlock.title = block.getTitle();
                extendedBlock.level = block.getLevel();
                break;
            }
            case "table": {
                extendedBlock.title = block.getTitle();
                extendedBlock.sourceText = this.getTableSource((TableImpl)block);
                extendedBlock.htmlText = StringEscapeUtils.escapeHtml4(block.convert());
            }
        }
        extendedBlock.docTitle = block.getDocument().getDoctitle();
        this.allBlocks.add(extendedBlock);
        if (extendedBlock.context.endsWith("list")) {
            HashMap<String, String> blockParams = new HashMap<String, String>();
            blockParams.put("id", extendedBlock.id);
            blockParams.put("style", DefaultValueHandler.getValueOrDefault(extendedBlock.style, ""));
            blockParams.put("isEmbeddedDoc", extendedBlock.isEmbeddedDoc.toString());
            blockParams.put("docTitle", extendedBlock.docTitle);
            this.addNestedItems(block, blockParams);
        }
    }

    private String getTableSource(TableImpl table) {
        String rowSourceText;
        String sourceText = "|===";
        for (Row header : table.getHeader()) {
            rowSourceText = this.getRowSource(header);
            if (rowSourceText.equals("")) continue;
            sourceText = String.join((CharSequence)"\n\n", sourceText, rowSourceText);
        }
        for (Row footer : table.getFooter()) {
            rowSourceText = this.getRowSource(footer);
            if (rowSourceText.equals("")) continue;
            sourceText = String.join((CharSequence)"\n\n", sourceText, rowSourceText);
        }
        for (Row body2 : table.getBody()) {
            rowSourceText = this.getRowSource(body2);
            if (rowSourceText.equals("")) continue;
            sourceText = String.join((CharSequence)"\n\n", sourceText, rowSourceText);
        }
        sourceText = String.join((CharSequence)"\n", sourceText, "|===");
        return sourceText;
    }

    private String getRowSource(Row row) {
        String rowSource = "";
        for (Cell cell : row.getCells()) {
            Object cellSource = cell.getSource();
            Object style = cell.getAttributes().get("style");
            if (style != null && style.toString().equals("asciidoc")) {
                cellSource = (String)cellSource + "\n";
            }
            rowSource = String.join((CharSequence)"|", new CharSequence[]{rowSource, cellSource});
        }
        return rowSource;
    }

    private void addNestedItems(StructuralNode block, Map blockParams) {
        block8: {
            block6: {
                block7: {
                    if (!block.getContext().endsWith("list")) break block6;
                    if (!(block instanceof ListImpl)) break block7;
                    for (StructuralNode listItem : ((ListImpl)block).getItems()) {
                        this.addListItem((ListItem)listItem, blockParams);
                    }
                    break block8;
                }
                if (!(block instanceof DescriptionListImpl)) break block8;
                for (DescriptionListEntry listItem : ((DescriptionListImpl)block).getItems()) {
                    this.addListItem(listItem, blockParams);
                }
                break block8;
            }
            if (block.getContext().equals("table")) {
                TableImpl table = (TableImpl)block;
                for (Row header : table.getHeader()) {
                    this.checkRows(header, blockParams);
                }
                for (Row footer : table.getFooter()) {
                    this.checkRows(footer, blockParams);
                }
                for (Row body2 : table.getBody()) {
                    this.checkRows(body2, blockParams);
                }
            }
        }
    }

    private void addListItem(ListItem listItem, Map listParams) {
        ExtendedBlock extendedBlock = new ExtendedBlock();
        extendedBlock.context = listItem.getContext();
        extendedBlock.id = this.getInlineId(listItem.getSource(), listParams);
        this.identify(extendedBlock);
        extendedBlock.parentId = listParams.get("id").toString();
        extendedBlock.isEmbeddedDoc = Boolean.parseBoolean(listParams.get("isEmbeddedDoc").toString());
        if (listItem.getSourceLocation() != null) {
            extendedBlock.sourceLine = listItem.getSourceLocation().getLineNumber();
            extendedBlock.marker = listItem.getMarker();
        } else {
            extendedBlock.marker = listItem.getMarker();
        }
        extendedBlock.sourceText = listItem.getSource();
        extendedBlock.htmlText = StringEscapeUtils.escapeHtml4(listItem.getText());
        extendedBlock.docTitle = listItem.getDocument().getDoctitle();
        this.allBlocks.add(extendedBlock);
        if (listItem.getBlocks().size() != 0) {
            for (StructuralNode listBlock : listItem.getBlocks()) {
                this.addBlock(listBlock, Boolean.parseBoolean(listParams.get("isEmbeddedDoc").toString()));
            }
        }
    }

    private void identify(ExtendedBlock extendedBlock) {
        if (extendedBlock.id != null) {
            extendedBlock.isIdentified = true;
        } else {
            IdGenerator idGenerator = new IdGenerator();
            extendedBlock.id = String.join((CharSequence)"_", extendedBlock.context, idGenerator.generateId(6));
            extendedBlock.id = extendedBlock.id.toLowerCase();
        }
    }

    private void addListItem(DescriptionListEntry listItem, Map listParams) {
        ExtendedBlock extendedBlock = new ExtendedBlock();
        extendedBlock.context = "list_item";
        ListItem term = listItem.getTerms().get(0);
        ListItem description = listItem.getDescription();
        extendedBlock.term = term.getSource();
        extendedBlock.description = description.getSource();
        extendedBlock.sourceText = String.format("%s:: %s", extendedBlock.term, extendedBlock.description);
        extendedBlock.htmlText = String.format("%s %s", StringEscapeUtils.escapeHtml4(term.getText()), StringEscapeUtils.escapeHtml4(description.getText()));
        extendedBlock.id = this.getInlineId(extendedBlock.sourceText, listParams);
        this.identify(extendedBlock);
        extendedBlock.parentId = listParams.get("id").toString();
        extendedBlock.isEmbeddedDoc = Boolean.parseBoolean(listParams.get("isEmbeddedDoc").toString());
        extendedBlock.docTitle = listParams.get("docTitle").toString();
        this.allBlocks.add(extendedBlock);
    }

    private String getInlineId(String sourceText, Map blockParams) {
        String result2 = null;
        String beginText = sourceText.split("\\r?\\n")[0];
        if (blockParams.get("style") != null && blockParams.get("style").toString().equals("bibliography")) {
            Pattern InlineBiblioAnchorRx = Pattern.compile("^\\[\\[\\[([\\p{Alpha}_:][\\w:.-]*)(?:, *(.+?))?]]].*");
            Matcher m = InlineBiblioAnchorRx.matcher(beginText);
            if (m.matches()) {
                result2 = m.group(1);
            }
        } else {
            Pattern InlineAnchorRx = Pattern.compile("(?:\\\\)?(?:\\[\\[([\\p{Alpha}_:][\\w:.-]*)(?:, *(.+?))?]]|anchor:([\\p{Alpha}_:][\\w:.-]*)\\[(?:]|(.*?[^\\\\])])).*");
            Matcher m = InlineAnchorRx.matcher(beginText);
            if (m.matches()) {
                result2 = m.group(1) != null ? m.group(1) : m.group(3);
            }
        }
        return result2;
    }

    private void checkRows(Row row, Map tableParams) {
        for (Cell cell : row.getCells()) {
            this.addCellItem(cell, tableParams);
        }
    }

    private void addCellItem(Cell cell, Map tableParams) {
        Object style = cell.getAttributes().get("style");
        if (style != null) {
            if (style.toString().equals("asciidoc")) {
                Asciidoctor asciidoctor = Asciidoctor.Factory.create();
                Options options2 = Options.builder().sourcemap(true).catalogAssets(true).build();
                Document document = asciidoctor.load(cell.getSource(), options2);
                this.touch(document, true);
            }
        } else {
            ExtendedBlock extendedBlock = new ExtendedBlock();
            extendedBlock.context = cell.getContext();
            extendedBlock.id = this.getInlineId(cell.getSource(), tableParams);
            this.identify(extendedBlock);
            extendedBlock.parentId = tableParams.get("id").toString();
            extendedBlock.isEmbeddedDoc = Boolean.parseBoolean(tableParams.get("isEmbeddedDoc").toString());
            extendedBlock.sourceText = cell.getSource();
            extendedBlock.htmlText = StringEscapeUtils.escapeHtml4(cell.getText());
            extendedBlock.docTitle = cell.getDocument().getDoctitle();
            this.allBlocks.add(extendedBlock);
        }
    }

    ArrayList<ExtendedBlock> lurk() {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        Attributes attributes = Attributes.builder().attribute("table-caption", "\u0422\u0430\u0431\u043b\u0438\u0446\u0430").attribute("!sectids").build();
        Options options2 = Options.builder().sourcemap(true).catalogAssets(true).attributes(attributes).build();
        Document document = asciidoctor.loadFile(new File(this.path), options2);
        this.touch(document, false);
        this.allBlocks.sort(Comparator.comparingInt(lhs -> lhs.sourceLine));
        HashSet<Integer> processedSourceLines = new HashSet<Integer>();
        int i2 = 0;
        while (i2 < this.allBlocks.size()) {
            if (this.allBlocks.get((int)i2).sourceText == null && this.allBlocks.get((int)i2).title == null) {
                this.allBlocks.remove(i2);
                continue;
            }
            if (this.allBlocks.get((int)i2).sourceText != null && this.allBlocks.get((int)i2).sourceText.trim().isEmpty()) {
                this.allBlocks.remove(i2);
                continue;
            }
            if (processedSourceLines.contains(this.allBlocks.get((int)i2).sourceLine)) {
                this.allBlocks.remove(i2);
                continue;
            }
            processedSourceLines.add(this.allBlocks.get((int)i2).sourceLine);
            ++i2;
        }
        for (i2 = 0; i2 < this.allBlocks.size(); ++i2) {
            if (i2 != 0) {
                this.allBlocks.get((int)i2).previousSourceLine = this.allBlocks.get((int)(i2 - 1)).sourceLine;
                continue;
            }
            if (i2 == this.allBlocks.size() - 1) continue;
            this.allBlocks.get((int)i2).nextSourceLine = this.allBlocks.get((int)(i2 + 1)).sourceLine;
        }
        return this.allBlocks;
    }
}

