/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.asciidoctor_idgen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.curs.asciidoctor_idgen.ExtendedBlock;

class Extender {
    private String outPath;
    private String jsonFilePath;
    private String copyPath;
    private ArrayList<ExtendedBlock> allBlocks;
    private ArrayList<String> lines;
    private int shift = 0;

    Extender(String path2, String outPath, String jsonFilePath, ArrayList<ExtendedBlock> allBlocks) throws IOException {
        String nextLine;
        this.outPath = outPath;
        this.jsonFilePath = jsonFilePath;
        this.allBlocks = allBlocks;
        this.lines = new ArrayList();
        int lastDot = path2.lastIndexOf(46);
        this.copyPath = path2.substring(0, lastDot) + "_copy" + path2.substring(lastDot);
        Files.copy(new File(path2).toPath(), new File(this.copyPath).toPath(), StandardCopyOption.REPLACE_EXISTING);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.copyPath)), StandardCharsets.UTF_8));
        while ((nextLine = bufferedReader.readLine()) != null) {
            this.lines.add(nextLine);
        }
        bufferedReader.close();
    }

    void extend() throws IOException {
        int all_block_idx = 0;
        for (ExtendedBlock extendedBlock : this.allBlocks) {
            if (!extendedBlock.isIdentified.booleanValue() && !extendedBlock.isEmbeddedDoc.booleanValue()) {
                if (extendedBlock.context.equals("paragraph") || extendedBlock.context.equals("section")) {
                    int paragraphAnchorLineIdx = extendedBlock.sourceLine + this.shift - 1;
                    paragraphAnchorLineIdx = this.fixParagraphAnchorLineIdx(all_block_idx, extendedBlock, paragraphAnchorLineIdx, this.shift);
                    try {
                        this.lines.add(paragraphAnchorLineIdx, "[[" + extendedBlock.id + "]]");
                        ++this.shift;
                        extendedBlock.isIdentified = true;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.err.println(String.format("Source line: %s, Shift %s, Error message: %s", extendedBlock.sourceLine, this.shift, e.getMessage()));
                    }
                } else if (extendedBlock.context.equals("image")) {
                    this.lines.add(extendedBlock.sourceLine + this.shift - 1, "[[" + extendedBlock.id + "]]");
                    ++this.shift;
                    extendedBlock.isIdentified = true;
                } else if (extendedBlock.context.equals("table")) {
                    this.lines.add(extendedBlock.sourceLine + this.shift - 1 - 1, "[[" + extendedBlock.id + "]]");
                    ++this.shift;
                    extendedBlock.isIdentified = true;
                } else if (extendedBlock.context.equals("cell")) {
                    this.addNestedId(all_block_idx, extendedBlock);
                } else if (extendedBlock.context.contains("list_item")) {
                    this.addNestedId(all_block_idx, extendedBlock);
                }
            }
            ++all_block_idx;
        }
        if (this.jsonFilePath != null) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.jsonFilePath)), StandardCharsets.UTF_8));){
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.disableHtmlEscaping();
                gsonBuilder.setPrettyPrinting();
                Gson gson = gsonBuilder.create();
                gson.toJson(this.allBlocks, (Appendable)writer);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outPath)), StandardCharsets.UTF_8));
        for (String line : this.lines) {
            out.append(line).append("\r\n");
        }
        ((Writer)out).flush();
        ((Writer)out).close();
        Files.delete(new File(this.copyPath).toPath());
    }

    private int fixParagraphAnchorLineIdx(int all_block_idx, ExtendedBlock extendedBlock, int paragraphAnchorLineIdx, int shift2) {
        int newParagraphAnchorLineIdx = paragraphAnchorLineIdx;
        ExtendedBlock prevIdentifiedBlock = this.getPrevIdentifiedBlock(all_block_idx, extendedBlock);
        for (int line_idx = prevIdentifiedBlock.sourceLine + shift2; line_idx < this.lines.size(); ++line_idx) {
            String line = this.lines.get(line_idx).trim();
            String sourceText = extendedBlock.sourceText;
            if (Objects.equals(extendedBlock.context, "section")) {
                sourceText = extendedBlock.title;
            }
            String lineToCompare = line;
            if (Objects.equals(extendedBlock.context, "section") && !line.isEmpty()) {
                lineToCompare = line.replaceFirst("^[=]+[ ]", "");
            }
            if (line.isEmpty() || !sourceText.startsWith(lineToCompare)) continue;
            newParagraphAnchorLineIdx = line_idx;
            extendedBlock.sourceLine = line_idx - shift2 + 1;
            break;
        }
        return newParagraphAnchorLineIdx;
    }

    private ExtendedBlock getPrevIdentifiedBlock(int all_block_idx, ExtendedBlock extendedBlock) {
        for (int identified_block_idx = all_block_idx - 1; identified_block_idx >= 0; --identified_block_idx) {
            ExtendedBlock prevIdentifiedBlock = this.allBlocks.get(identified_block_idx);
            if (!prevIdentifiedBlock.isIdentified.booleanValue()) continue;
            return prevIdentifiedBlock;
        }
        return extendedBlock;
    }

    private void addNestedId(int all_block_idx, ExtendedBlock extendedBlock) {
        if (extendedBlock.sourceText == null) {
            return;
        }
        if (!extendedBlock.sourceText.equals("")) {
            String beginText = extendedBlock.sourceText.split("\\r?\\n")[0];
            ExtendedBlock parentBlock = this.getParentBlock(extendedBlock);
            ExtendedBlock prevIdentifiedBlock = this.getPrevIdentifiedBlock(all_block_idx, extendedBlock);
            for (int line_idx = extendedBlock.previousSourceLine + this.shift; line_idx < (extendedBlock.nextSourceLine != 0 ? extendedBlock.nextSourceLine + this.shift : this.lines.size()); ++line_idx) {
                Pattern DescriptionListRx;
                Matcher m;
                String line = this.lines.get(line_idx).trim();
                if (!extendedBlock.context.contains("list_item") || extendedBlock.sourceText.length() < 3) continue;
                if (extendedBlock.marker != null) {
                    String marker = this.normalizeMarker(extendedBlock.marker);
                    Pattern SimpleListRx = marker.equals(extendedBlock.marker) ? (Character.isLetter(marker.charAt(0)) ? Pattern.compile(String.format("^[ \\t]*\\p{Alpha}(%s)[ \\t]+(%s)$", Pattern.quote(marker.substring(marker.length() - 1)), Pattern.quote(beginText))) : Pattern.compile(String.format("^[ \\t]*(%s)[ \\t]+(%s)$", Pattern.quote(marker), Pattern.quote(beginText)))) : Pattern.compile(String.format("^[ \\t]*\\d*(%s)[ \\t]+(%s)$", Pattern.quote(marker), Pattern.quote(beginText)));
                    Matcher m2 = SimpleListRx.matcher(line.trim());
                    if (!m2.matches()) continue;
                    if (parentBlock.style != null && parentBlock.style.equals("bibliography")) {
                        this.lines.set(line_idx, String.format("%s [[[%s]]] %s", marker, extendedBlock.id, extendedBlock.sourceText));
                    } else {
                        this.lines.set(line_idx, String.format("%s [[%s]]%s", marker, extendedBlock.id, beginText));
                    }
                    extendedBlock.sourceLine = line_idx - this.shift + 1;
                    extendedBlock.isIdentified = true;
                    break;
                }
                if (extendedBlock.term == null || extendedBlock.description == null || !(m = (DescriptionListRx = Pattern.compile(String.format("^(?!//)[ \\t]*(%s?)(:{2,4}|;;)(?:[ \\t]+(%s))?$", Pattern.quote(extendedBlock.term), Pattern.quote(extendedBlock.description.split("\\r?\\n")[0])))).matcher(line.trim())).matches()) continue;
                this.lines.set(line_idx, String.format("[[%s]]%s", extendedBlock.id, line));
                extendedBlock.sourceLine = line_idx - this.shift + 1;
                extendedBlock.isIdentified = true;
                break;
            }
        }
    }

    private ExtendedBlock getParentBlock(ExtendedBlock extendedBlock) {
        ExtendedBlock parentBlock = new ExtendedBlock();
        for (ExtendedBlock block : this.allBlocks) {
            if (!extendedBlock.parentId.equals(block.id)) continue;
            parentBlock = block;
            break;
        }
        return parentBlock;
    }

    private String normalizeMarker(String marker) {
        String normalizedMarker = marker;
        Pattern markerRx = Pattern.compile("^\\d+\\t*(.*)$");
        Matcher m = markerRx.matcher(marker.trim());
        if (m.matches()) {
            normalizedMarker = m.group(1);
        }
        return normalizedMarker;
    }
}

