/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.asciidoctor_idgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import ru.curs.asciidoctor_idgen.OutputLog;

class Converter {
    private String adocFilePath;

    public static String removeFileExtension(String filename2, boolean removeAllExtensions) {
        if (filename2 == null || filename2.isEmpty()) {
            return filename2;
        }
        String extPattern = "(?<!^)[.]" + (removeAllExtensions ? ".*" : "[^.]*$");
        return filename2.replaceAll(extPattern, "");
    }

    Converter(String adocFilePath) {
        this.adocFilePath = adocFilePath;
    }

    void nodeDescendant(ArrayList<Node> nodes, Node nodeToProcess) {
        nodes.add(nodeToProcess);
        nodeToProcess.childNodes().forEach(childNode -> this.nodeDescendant(nodes, (Node)childNode));
    }

    OutputLog convert() {
        Document jsoup;
        OutputLog outputLog = new OutputLog();
        try (Asciidoctor asciidoctor = Asciidoctor.Factory.create();){
            asciidoctor.registerLogHandler(logRecord -> {
                String fullLogMessage = String.format("%s: %s", new Object[]{logRecord.getSeverity(), logRecord.getMessage()});
                System.out.println(fullLogMessage);
                outputLog.add(logRecord.getSeverity().name(), logRecord.getMessage());
            });
            System.out.println(this.adocFilePath);
            System.out.println(new File(this.adocFilePath).getParentFile());
            File baseDir = new File("./" + this.adocFilePath).getParentFile();
            Options options2 = Options.builder().safe(SafeMode.UNSAFE).baseDir(baseDir).build();
            asciidoctor.convertFile(new File(this.adocFilePath), options2);
        }
        String outputHtmlPath = String.format("%s.html", Converter.removeFileExtension(this.adocFilePath, false));
        try {
            jsoup = Jsoup.parse(new File(outputHtmlPath));
        }
        catch (IOException e) {
            throw new RuntimeException("Output Html not found", e);
        }
        System.out.println("Converted to html successfully");
        outputLog.add("INFO", "Converted to html successfully");
        jsoup.selectXpath("//li").forEach(listItem -> {
            ArrayList<Node> descendant = new ArrayList<Node>();
            this.nodeDescendant(descendant, (Node)listItem);
            descendant.stream().filter(node -> node instanceof Element).forEach(child -> {
                Element childElement = (Element)child;
                if (child.nodeName().equals("a") && !childElement.id().isBlank()) {
                    String id2 = childElement.id();
                    childElement.id(String.format("anchor_%s", id2));
                    listItem.id(id2);
                }
            });
        });
        try (PrintWriter out = new PrintWriter(outputHtmlPath);){
            out.print(jsoup);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Can't overwrite resulting html", e);
        }
        return outputLog;
    }
}

