/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.external.com.google.gdata.util.common.base;

import java.io.IOException;
import org.yaml.snakeyaml.external.com.google.gdata.util.common.base.Escaper;

public abstract class UnicodeEscaper
implements Escaper {
    private static final int DEST_PAD = 32;
    private static final ThreadLocal<char[]> DEST_TL = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1024];
        }
    };

    protected abstract char[] escape(int var1);

    protected int nextEscapeIndex(CharSequence csq, int start2, int end2) {
        int index2;
        int cp;
        for (index2 = start2; index2 < end2 && (cp = UnicodeEscaper.codePointAt(csq, index2, end2)) >= 0 && this.escape(cp) == null; index2 += Character.isSupplementaryCodePoint(cp) ? 2 : 1) {
        }
        return index2;
    }

    @Override
    public String escape(String string2) {
        int end2 = string2.length();
        int index2 = this.nextEscapeIndex(string2, 0, end2);
        return index2 == end2 ? string2 : this.escapeSlow(string2, index2);
    }

    protected final String escapeSlow(String s2, int index2) {
        int end2 = s2.length();
        char[] dest = DEST_TL.get();
        int destIndex = 0;
        int unescapedChunkStart = 0;
        while (index2 < end2) {
            int cp = UnicodeEscaper.codePointAt(s2, index2, end2);
            if (cp < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] escaped = this.escape(cp);
            if (escaped != null) {
                int charsSkipped = index2 - unescapedChunkStart;
                int sizeNeeded = destIndex + charsSkipped + escaped.length;
                if (dest.length < sizeNeeded) {
                    int destLength = sizeNeeded + (end2 - index2) + 32;
                    dest = UnicodeEscaper.growBuffer(dest, destIndex, destLength);
                }
                if (charsSkipped > 0) {
                    s2.getChars(unescapedChunkStart, index2, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (escaped.length > 0) {
                    System.arraycopy(escaped, 0, dest, destIndex, escaped.length);
                    destIndex += escaped.length;
                }
            }
            unescapedChunkStart = index2 + (Character.isSupplementaryCodePoint(cp) ? 2 : 1);
            index2 = this.nextEscapeIndex(s2, unescapedChunkStart, end2);
        }
        int charsSkipped = end2 - unescapedChunkStart;
        if (charsSkipped > 0) {
            int endIndex = destIndex + charsSkipped;
            if (dest.length < endIndex) {
                dest = UnicodeEscaper.growBuffer(dest, destIndex, endIndex);
            }
            s2.getChars(unescapedChunkStart, end2, dest, destIndex);
            destIndex = endIndex;
        }
        return new String(dest, 0, destIndex);
    }

    @Override
    public Appendable escape(final Appendable out) {
        assert (out != null);
        return new Appendable(){
            int pendingHighSurrogate = -1;
            final char[] decodedChars = new char[2];

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                return this.append(csq, 0, csq.length());
            }

            @Override
            public Appendable append(CharSequence csq, int start2, int end2) throws IOException {
                int index2 = start2;
                if (index2 < end2) {
                    char[] escaped;
                    int unescapedChunkStart = index2;
                    if (this.pendingHighSurrogate != -1) {
                        char c;
                        if (!Character.isLowSurrogate(c = csq.charAt(index2++))) {
                            throw new IllegalArgumentException("Expected low surrogate character but got " + c);
                        }
                        escaped = UnicodeEscaper.this.escape(Character.toCodePoint((char)this.pendingHighSurrogate, c));
                        if (escaped != null) {
                            this.outputChars(escaped, escaped.length);
                            ++unescapedChunkStart;
                        } else {
                            out.append((char)this.pendingHighSurrogate);
                        }
                        this.pendingHighSurrogate = -1;
                    }
                    while (true) {
                        if ((index2 = UnicodeEscaper.this.nextEscapeIndex(csq, index2, end2)) > unescapedChunkStart) {
                            out.append(csq, unescapedChunkStart, index2);
                        }
                        if (index2 == end2) break;
                        int cp = UnicodeEscaper.codePointAt(csq, index2, end2);
                        if (cp < 0) {
                            this.pendingHighSurrogate = -cp;
                            break;
                        }
                        escaped = UnicodeEscaper.this.escape(cp);
                        if (escaped != null) {
                            this.outputChars(escaped, escaped.length);
                        } else {
                            int len = Character.toChars(cp, this.decodedChars, 0);
                            this.outputChars(this.decodedChars, len);
                        }
                        unescapedChunkStart = index2 += Character.isSupplementaryCodePoint(cp) ? 2 : 1;
                    }
                }
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                if (this.pendingHighSurrogate != -1) {
                    if (!Character.isLowSurrogate(c)) {
                        throw new IllegalArgumentException("Expected low surrogate character but got '" + c + "' with value " + c);
                    }
                    char[] escaped = UnicodeEscaper.this.escape(Character.toCodePoint((char)this.pendingHighSurrogate, c));
                    if (escaped != null) {
                        this.outputChars(escaped, escaped.length);
                    } else {
                        out.append((char)this.pendingHighSurrogate);
                        out.append(c);
                    }
                    this.pendingHighSurrogate = -1;
                } else if (Character.isHighSurrogate(c)) {
                    this.pendingHighSurrogate = c;
                } else {
                    if (Character.isLowSurrogate(c)) {
                        throw new IllegalArgumentException("Unexpected low surrogate character '" + c + "' with value " + c);
                    }
                    char[] escaped = UnicodeEscaper.this.escape(c);
                    if (escaped != null) {
                        this.outputChars(escaped, escaped.length);
                    } else {
                        out.append(c);
                    }
                }
                return this;
            }

            private void outputChars(char[] chars2, int len) throws IOException {
                for (int n = 0; n < len; ++n) {
                    out.append(chars2[n]);
                }
            }
        };
    }

    protected static final int codePointAt(CharSequence seq, int index2, int end2) {
        if (index2 < end2) {
            char c1;
            if ((c1 = seq.charAt(index2++)) < '\ud800' || c1 > '\udfff') {
                return c1;
            }
            if (c1 <= '\udbff') {
                if (index2 == end2) {
                    return -c1;
                }
                char c2 = seq.charAt(index2);
                if (Character.isLowSurrogate(c2)) {
                    return Character.toCodePoint(c1, c2);
                }
                throw new IllegalArgumentException("Expected low surrogate but got char '" + c2 + "' with value " + c2 + " at index " + index2);
            }
            throw new IllegalArgumentException("Unexpected low surrogate character '" + c1 + "' with value " + c1 + " at index " + (index2 - 1));
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static final char[] growBuffer(char[] dest, int index2, int size2) {
        char[] copy2 = new char[size2];
        if (index2 > 0) {
            System.arraycopy(dest, 0, copy2, 0, index2);
        }
        return copy2;
    }
}

