/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;

class LiteralPathElement
extends PathElement {
    private final String text;
    private final int len;
    private final boolean caseSensitive;

    public LiteralPathElement(int pos2, char[] literalText, boolean caseSensitive, char separator) {
        super(pos2, separator);
        this.len = literalText.length;
        this.caseSensitive = caseSensitive;
        this.text = new String(literalText);
    }

    @Override
    public boolean matches(int pathIndex, PathPattern.MatchingContext matchingContext) {
        if (pathIndex >= matchingContext.pathLength) {
            return false;
        }
        PathContainer.Element element = matchingContext.pathElements.get(pathIndex);
        if (!(element instanceof PathContainer.PathSegment)) {
            return false;
        }
        PathContainer.PathSegment pathSegment = (PathContainer.PathSegment)element;
        String value2 = pathSegment.valueToMatch();
        if (value2.length() != this.len) {
            return false;
        }
        if (this.caseSensitive ? !this.text.equals(value2) : !this.text.equalsIgnoreCase(value2)) {
            return false;
        }
        ++pathIndex;
        if (this.isNoMorePattern()) {
            if (matchingContext.determineRemainingPath) {
                matchingContext.remainingPathIndex = pathIndex;
                return true;
            }
            if (pathIndex == matchingContext.pathLength) {
                return true;
            }
            return matchingContext.isMatchOptionalTrailingSeparator() && pathIndex + 1 == matchingContext.pathLength && matchingContext.isSeparator(pathIndex);
        }
        return this.next != null && this.next.matches(pathIndex, matchingContext);
    }

    @Override
    public int getNormalizedLength() {
        return this.len;
    }

    @Override
    public char[] getChars() {
        return this.text.toCharArray();
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    public String toString() {
        return "Literal(" + this.text + ")";
    }
}

