/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HierarchicalUriComponents;

public abstract class UriUtils {
    public static String encodeScheme(String scheme, String encoding2) {
        return UriUtils.encode(scheme, encoding2, HierarchicalUriComponents.Type.SCHEME);
    }

    public static String encodeScheme(String scheme, Charset charset) {
        return UriUtils.encode(scheme, charset, HierarchicalUriComponents.Type.SCHEME);
    }

    public static String encodeAuthority(String authority, String encoding2) {
        return UriUtils.encode(authority, encoding2, HierarchicalUriComponents.Type.AUTHORITY);
    }

    public static String encodeAuthority(String authority, Charset charset) {
        return UriUtils.encode(authority, charset, HierarchicalUriComponents.Type.AUTHORITY);
    }

    public static String encodeUserInfo(String userInfo, String encoding2) {
        return UriUtils.encode(userInfo, encoding2, HierarchicalUriComponents.Type.USER_INFO);
    }

    public static String encodeUserInfo(String userInfo, Charset charset) {
        return UriUtils.encode(userInfo, charset, HierarchicalUriComponents.Type.USER_INFO);
    }

    public static String encodeHost(String host, String encoding2) {
        return UriUtils.encode(host, encoding2, HierarchicalUriComponents.Type.HOST_IPV4);
    }

    public static String encodeHost(String host, Charset charset) {
        return UriUtils.encode(host, charset, HierarchicalUriComponents.Type.HOST_IPV4);
    }

    public static String encodePort(String port, String encoding2) {
        return UriUtils.encode(port, encoding2, HierarchicalUriComponents.Type.PORT);
    }

    public static String encodePort(String port, Charset charset) {
        return UriUtils.encode(port, charset, HierarchicalUriComponents.Type.PORT);
    }

    public static String encodePath(String path2, String encoding2) {
        return UriUtils.encode(path2, encoding2, HierarchicalUriComponents.Type.PATH);
    }

    public static String encodePath(String path2, Charset charset) {
        return UriUtils.encode(path2, charset, HierarchicalUriComponents.Type.PATH);
    }

    public static String encodePathSegment(String segment, String encoding2) {
        return UriUtils.encode(segment, encoding2, HierarchicalUriComponents.Type.PATH_SEGMENT);
    }

    public static String encodePathSegment(String segment, Charset charset) {
        return UriUtils.encode(segment, charset, HierarchicalUriComponents.Type.PATH_SEGMENT);
    }

    public static String encodeQuery(String query, String encoding2) {
        return UriUtils.encode(query, encoding2, HierarchicalUriComponents.Type.QUERY);
    }

    public static String encodeQuery(String query, Charset charset) {
        return UriUtils.encode(query, charset, HierarchicalUriComponents.Type.QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding2) {
        return UriUtils.encode(queryParam, encoding2, HierarchicalUriComponents.Type.QUERY_PARAM);
    }

    public static String encodeQueryParam(String queryParam, Charset charset) {
        return UriUtils.encode(queryParam, charset, HierarchicalUriComponents.Type.QUERY_PARAM);
    }

    public static MultiValueMap<String, String> encodeQueryParams(MultiValueMap<String, String> params2) {
        Charset charset = StandardCharsets.UTF_8;
        LinkedMultiValueMap<String, String> result2 = new LinkedMultiValueMap<String, String>(params2.size());
        for (Map.Entry entry : params2.entrySet()) {
            for (String value2 : (List)entry.getValue()) {
                result2.add(UriUtils.encodeQueryParam((String)entry.getKey(), charset), UriUtils.encodeQueryParam(value2, charset));
            }
        }
        return result2;
    }

    public static String encodeFragment(String fragment, String encoding2) {
        return UriUtils.encode(fragment, encoding2, HierarchicalUriComponents.Type.FRAGMENT);
    }

    public static String encodeFragment(String fragment, Charset charset) {
        return UriUtils.encode(fragment, charset, HierarchicalUriComponents.Type.FRAGMENT);
    }

    public static String encode(String source2, String encoding2) {
        return UriUtils.encode(source2, encoding2, HierarchicalUriComponents.Type.URI);
    }

    public static String encode(String source2, Charset charset) {
        return UriUtils.encode(source2, charset, HierarchicalUriComponents.Type.URI);
    }

    public static Map<String, String> encodeUriVariables(Map<String, ?> uriVariables) {
        LinkedHashMap<String, String> result2 = CollectionUtils.newLinkedHashMap(uriVariables.size());
        uriVariables.forEach((key2, value2) -> {
            String stringValue = value2 != null ? value2.toString() : "";
            result2.put((String)key2, UriUtils.encode(stringValue, StandardCharsets.UTF_8));
        });
        return result2;
    }

    public static Object[] encodeUriVariables(Object ... uriVariables) {
        return Arrays.stream(uriVariables).map(value2 -> {
            String stringValue = value2 != null ? value2.toString() : "";
            return UriUtils.encode(stringValue, StandardCharsets.UTF_8);
        }).toArray();
    }

    private static String encode(String scheme, String encoding2, HierarchicalUriComponents.Type type2) {
        return HierarchicalUriComponents.encodeUriComponent(scheme, encoding2, type2);
    }

    private static String encode(String scheme, Charset charset, HierarchicalUriComponents.Type type2) {
        return HierarchicalUriComponents.encodeUriComponent(scheme, charset, type2);
    }

    public static String decode(String source2, String encoding2) {
        return StringUtils.uriDecode(source2, Charset.forName(encoding2));
    }

    public static String decode(String source2, Charset charset) {
        return StringUtils.uriDecode(source2, charset);
    }

    @Nullable
    public static String extractFileExtension(String path2) {
        int begin2;
        int paramIndex;
        int extIndex;
        int end2 = path2.indexOf(63);
        int fragmentIndex = path2.indexOf(35);
        if (fragmentIndex != -1 && (end2 == -1 || fragmentIndex < end2)) {
            end2 = fragmentIndex;
        }
        if (end2 == -1) {
            end2 = path2.length();
        }
        if ((extIndex = path2.lastIndexOf(46, end2 = (paramIndex = path2.indexOf(59, begin2 = path2.lastIndexOf(47, end2) + 1)) != -1 && paramIndex < end2 ? paramIndex : end2)) != -1 && extIndex >= begin2) {
            return path2.substring(extIndex + 1, end2);
        }
        return null;
    }
}

