/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class UriComponents
implements Serializable {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    @Nullable
    private final String scheme;
    @Nullable
    private final String fragment;

    protected UriComponents(@Nullable String scheme, @Nullable String fragment) {
        this.scheme = scheme;
        this.fragment = fragment;
    }

    @Nullable
    public final String getScheme() {
        return this.scheme;
    }

    @Nullable
    public final String getFragment() {
        return this.fragment;
    }

    @Nullable
    public abstract String getSchemeSpecificPart();

    @Nullable
    public abstract String getUserInfo();

    @Nullable
    public abstract String getHost();

    public abstract int getPort();

    @Nullable
    public abstract String getPath();

    public abstract List<String> getPathSegments();

    @Nullable
    public abstract String getQuery();

    public abstract MultiValueMap<String, String> getQueryParams();

    public final UriComponents encode() {
        return this.encode(StandardCharsets.UTF_8);
    }

    public abstract UriComponents encode(Charset var1);

    public final UriComponents expand(Map<String, ?> uriVariables) {
        Assert.notNull(uriVariables, "'uriVariables' must not be null");
        return this.expandInternal(new MapTemplateVariables(uriVariables));
    }

    public final UriComponents expand(Object ... uriVariableValues) {
        Assert.notNull((Object)uriVariableValues, "'uriVariableValues' must not be null");
        return this.expandInternal(new VarArgsTemplateVariables(uriVariableValues));
    }

    public final UriComponents expand(UriTemplateVariables uriVariables) {
        Assert.notNull((Object)uriVariables, "'uriVariables' must not be null");
        return this.expandInternal(uriVariables);
    }

    abstract UriComponents expandInternal(UriTemplateVariables var1);

    public abstract UriComponents normalize();

    public abstract String toUriString();

    public abstract URI toUri();

    public final String toString() {
        return this.toUriString();
    }

    protected abstract void copyToUriComponentsBuilder(UriComponentsBuilder var1);

    @Nullable
    static String expandUriComponent(@Nullable String source2, UriTemplateVariables uriVariables) {
        return UriComponents.expandUriComponent(source2, uriVariables, null);
    }

    @Nullable
    static String expandUriComponent(@Nullable String source2, UriTemplateVariables uriVariables, @Nullable UnaryOperator<String> encoder) {
        if (source2 == null) {
            return null;
        }
        if (source2.indexOf(123) == -1) {
            return source2;
        }
        if (source2.indexOf(58) != -1) {
            source2 = UriComponents.sanitizeSource(source2);
        }
        Matcher matcher = NAMES_PATTERN.matcher(source2);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String match2 = matcher.group(1);
            String varName = UriComponents.getVariableName(match2);
            Object varValue = uriVariables.getValue(varName);
            if (UriTemplateVariables.SKIP_VALUE.equals(varValue)) continue;
            String formatted = UriComponents.getVariableValueAsString(varValue);
            formatted = encoder != null ? (String)encoder.apply(formatted) : Matcher.quoteReplacement(formatted);
            matcher.appendReplacement(sb, formatted);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String sanitizeSource(String source2) {
        int level2 = 0;
        int lastCharIndex = 0;
        char[] chars2 = new char[source2.length()];
        for (int i2 = 0; i2 < source2.length(); ++i2) {
            char c = source2.charAt(i2);
            if (c == '{') {
                ++level2;
            }
            if (c == '}') {
                --level2;
            }
            if (level2 > 1 || level2 == 1 && c == '}') continue;
            chars2[lastCharIndex++] = c;
        }
        return new String(chars2, 0, lastCharIndex);
    }

    private static String getVariableName(String match2) {
        int colonIdx = match2.indexOf(58);
        return colonIdx != -1 ? match2.substring(0, colonIdx) : match2;
    }

    private static String getVariableValueAsString(@Nullable Object variableValue) {
        return variableValue != null ? variableValue.toString() : "";
    }

    private static class MapTemplateVariables
    implements UriTemplateVariables {
        private final Map<String, ?> uriVariables;

        public MapTemplateVariables(Map<String, ?> uriVariables) {
            this.uriVariables = uriVariables;
        }

        @Override
        @Nullable
        public Object getValue(@Nullable String name2) {
            if (!this.uriVariables.containsKey(name2)) {
                throw new IllegalArgumentException("Map has no value for '" + name2 + "'");
            }
            return this.uriVariables.get(name2);
        }
    }

    public static interface UriTemplateVariables {
        public static final Object SKIP_VALUE = UriTemplateVariables.class;

        @Nullable
        public Object getValue(@Nullable String var1);
    }

    private static class VarArgsTemplateVariables
    implements UriTemplateVariables {
        private final Iterator<Object> valueIterator;

        public VarArgsTemplateVariables(Object ... uriVariableValues) {
            this.valueIterator = Arrays.asList(uriVariableValues).iterator();
        }

        @Override
        @Nullable
        public Object getValue(@Nullable String name2) {
            if (!this.valueIterator.hasNext()) {
                throw new IllegalArgumentException("Not enough variable values available to expand '" + name2 + "'");
            }
            return this.valueIterator.next();
        }
    }
}

