/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import org.springframework.util.Assert;
import org.springframework.web.util.HtmlCharacterEntityDecoder;
import org.springframework.web.util.HtmlCharacterEntityReferences;

public abstract class HtmlUtils {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    public static String htmlEscape(String input) {
        return HtmlUtils.htmlEscape(input, "ISO-8859-1");
    }

    public static String htmlEscape(String input, String encoding2) {
        Assert.notNull((Object)input, "Input is required");
        Assert.notNull((Object)encoding2, "Encoding is required");
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char character = input.charAt(i2);
            String reference2 = characterEntityReferences.convertToReference(character, encoding2);
            if (reference2 != null) {
                escaped.append(reference2);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeDecimal(String input) {
        return HtmlUtils.htmlEscapeDecimal(input, "ISO-8859-1");
    }

    public static String htmlEscapeDecimal(String input, String encoding2) {
        Assert.notNull((Object)input, "Input is required");
        Assert.notNull((Object)encoding2, "Encoding is required");
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char character = input.charAt(i2);
            if (characterEntityReferences.isMappedToReference(character, encoding2)) {
                escaped.append("&#");
                escaped.append((int)character);
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeHex(String input) {
        return HtmlUtils.htmlEscapeHex(input, "ISO-8859-1");
    }

    public static String htmlEscapeHex(String input, String encoding2) {
        Assert.notNull((Object)input, "Input is required");
        Assert.notNull((Object)encoding2, "Encoding is required");
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char character = input.charAt(i2);
            if (characterEntityReferences.isMappedToReference(character, encoding2)) {
                escaped.append("&#x");
                escaped.append(Integer.toString(character, 16));
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlUnescape(String input) {
        return new HtmlCharacterEntityDecoder(characterEntityReferences, input).decode();
    }
}

