/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.springframework.lang.Nullable;
import org.springframework.util.FastByteArrayOutputStream;

public class ContentCachingResponseWrapper
extends HttpServletResponseWrapper {
    private final FastByteArrayOutputStream content = new FastByteArrayOutputStream(1024);
    @Nullable
    private ServletOutputStream outputStream;
    @Nullable
    private PrintWriter writer;
    @Nullable
    private Integer contentLength;

    public ContentCachingResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.copyBodyToResponse(false);
        try {
            super.sendError(sc);
        }
        catch (IllegalStateException ex) {
            super.setStatus(sc);
        }
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.copyBodyToResponse(false);
        try {
            super.sendError(sc, msg);
        }
        catch (IllegalStateException ex) {
            super.setStatus(sc);
        }
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.copyBodyToResponse(false);
        super.sendRedirect(location);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new ResponseServletOutputStream(this.getResponse().getOutputStream());
        }
        return this.outputStream;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            String characterEncoding = this.getCharacterEncoding();
            this.writer = characterEncoding != null ? new ResponsePrintWriter(characterEncoding) : new ResponsePrintWriter("ISO-8859-1");
        }
        return this.writer;
    }

    @Override
    public void flushBuffer() throws IOException {
    }

    @Override
    public void setContentLength(int len) {
        if (len > this.content.size()) {
            this.content.resize(len);
        }
        this.contentLength = len;
    }

    @Override
    public void setContentLengthLong(long len) {
        this.setContentLength(this.toContentLengthInt(len));
    }

    private int toContentLengthInt(long contentLength) {
        if (contentLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Content-Length exceeds ContentCachingResponseWrapper's maximum (2147483647): " + contentLength);
        }
        return (int)contentLength;
    }

    @Override
    public boolean containsHeader(String name2) {
        if (this.contentLength != null && "Content-Length".equalsIgnoreCase(name2)) {
            return true;
        }
        return super.containsHeader(name2);
    }

    @Override
    public void setHeader(String name2, String value2) {
        if ("Content-Length".equalsIgnoreCase(name2)) {
            this.contentLength = this.toContentLengthInt(Long.parseLong(value2));
        } else {
            super.setHeader(name2, value2);
        }
    }

    @Override
    public void addHeader(String name2, String value2) {
        if ("Content-Length".equalsIgnoreCase(name2)) {
            this.contentLength = this.toContentLengthInt(Long.parseLong(value2));
        } else {
            super.addHeader(name2, value2);
        }
    }

    @Override
    public void setIntHeader(String name2, int value2) {
        if ("Content-Length".equalsIgnoreCase(name2)) {
            this.contentLength = value2;
        } else {
            super.setIntHeader(name2, value2);
        }
    }

    @Override
    public void addIntHeader(String name2, int value2) {
        if ("Content-Length".equalsIgnoreCase(name2)) {
            this.contentLength = value2;
        } else {
            super.addIntHeader(name2, value2);
        }
    }

    @Override
    @Nullable
    public String getHeader(String name2) {
        if (this.contentLength != null && "Content-Length".equalsIgnoreCase(name2)) {
            return this.contentLength.toString();
        }
        return super.getHeader(name2);
    }

    @Override
    public Collection<String> getHeaders(String name2) {
        if (this.contentLength != null && "Content-Length".equalsIgnoreCase(name2)) {
            return Collections.singleton(this.contentLength.toString());
        }
        return super.getHeaders(name2);
    }

    @Override
    public Collection<String> getHeaderNames() {
        Collection<String> headerNames = super.getHeaderNames();
        if (this.contentLength != null) {
            LinkedHashSet<String> result2 = new LinkedHashSet<String>(headerNames);
            result2.add("Content-Length");
            return result2;
        }
        return headerNames;
    }

    @Override
    public void setBufferSize(int size2) {
        if (size2 > this.content.size()) {
            this.content.resize(size2);
        }
    }

    @Override
    public void resetBuffer() {
        this.content.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.content.reset();
    }

    public byte[] getContentAsByteArray() {
        return this.content.toByteArray();
    }

    public InputStream getContentInputStream() {
        return this.content.getInputStream();
    }

    public int getContentSize() {
        return this.content.size();
    }

    public void copyBodyToResponse() throws IOException {
        this.copyBodyToResponse(true);
    }

    protected void copyBodyToResponse(boolean complete) throws IOException {
        if (this.content.size() > 0) {
            HttpServletResponse rawResponse = (HttpServletResponse)this.getResponse();
            if (!rawResponse.isCommitted() && (complete || this.contentLength != null)) {
                if (rawResponse.getHeader("Transfer-Encoding") == null) {
                    rawResponse.setContentLength(complete ? this.content.size() : this.contentLength.intValue());
                }
                this.contentLength = null;
            }
            this.content.writeTo(rawResponse.getOutputStream());
            this.content.reset();
            if (complete) {
                super.flushBuffer();
            }
        }
    }

    private class ResponseServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream os;

        public ResponseServletOutputStream(ServletOutputStream os) {
            this.os = os;
        }

        @Override
        public void write(int b2) throws IOException {
            ContentCachingResponseWrapper.this.content.write(b2);
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            ContentCachingResponseWrapper.this.content.write(b2, off, len);
        }

        @Override
        public boolean isReady() {
            return this.os.isReady();
        }

        @Override
        public void setWriteListener(WriteListener writeListener) {
            this.os.setWriteListener(writeListener);
        }
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        public ResponsePrintWriter(String characterEncoding) throws UnsupportedEncodingException {
            super(new OutputStreamWriter((OutputStream)ContentCachingResponseWrapper.this.content, characterEncoding));
        }

        @Override
        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            super.flush();
        }

        @Override
        public void write(String s2, int off, int len) {
            super.write(s2, off, len);
            super.flush();
        }

        @Override
        public void write(int c) {
            super.write(c);
            super.flush();
        }
    }
}

