/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.FastByteArrayOutputStream;

public class ContentCachingRequestWrapper
extends HttpServletRequestWrapper {
    private final FastByteArrayOutputStream cachedContent;
    @Nullable
    private final Integer contentCacheLimit;
    @Nullable
    private ServletInputStream inputStream;
    @Nullable
    private BufferedReader reader;

    public ContentCachingRequestWrapper(HttpServletRequest request) {
        super(request);
        int contentLength = request.getContentLength();
        this.cachedContent = contentLength > 0 ? new FastByteArrayOutputStream(contentLength) : new FastByteArrayOutputStream();
        this.contentCacheLimit = null;
    }

    public ContentCachingRequestWrapper(HttpServletRequest request, int contentCacheLimit) {
        super(request);
        int contentLength = request.getContentLength();
        this.cachedContent = contentLength > 0 ? new FastByteArrayOutputStream(Math.min(contentLength, contentCacheLimit)) : new FastByteArrayOutputStream();
        this.contentCacheLimit = contentCacheLimit;
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new ContentCachingInputStream(this.getRequest().getInputStream());
        }
        return this.inputStream;
    }

    @Override
    public String getCharacterEncoding() {
        String enc = super.getCharacterEncoding();
        return enc != null ? enc : "ISO-8859-1";
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
        }
        return this.reader;
    }

    @Override
    public String getParameter(String name2) {
        if (this.cachedContent.size() == 0 && this.isFormPost()) {
            this.writeRequestParametersToCachedContent();
        }
        return super.getParameter(name2);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this.cachedContent.size() == 0 && this.isFormPost()) {
            this.writeRequestParametersToCachedContent();
        }
        return super.getParameterMap();
    }

    @Override
    public Enumeration<String> getParameterNames() {
        if (this.cachedContent.size() == 0 && this.isFormPost()) {
            this.writeRequestParametersToCachedContent();
        }
        return super.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name2) {
        if (this.cachedContent.size() == 0 && this.isFormPost()) {
            this.writeRequestParametersToCachedContent();
        }
        return super.getParameterValues(name2);
    }

    private boolean isFormPost() {
        String contentType = this.getContentType();
        return contentType != null && contentType.contains("application/x-www-form-urlencoded") && HttpMethod.POST.matches(this.getMethod());
    }

    private void writeRequestParametersToCachedContent() {
        try {
            if (this.cachedContent.size() == 0) {
                String requestEncoding = this.getCharacterEncoding();
                Map<String, String[]> form = super.getParameterMap();
                Iterator<String> nameIterator = form.keySet().iterator();
                while (nameIterator.hasNext()) {
                    String name2 = nameIterator.next();
                    List<String> values2 = Arrays.asList(form.get(name2));
                    Iterator<String> valueIterator = values2.iterator();
                    while (valueIterator.hasNext()) {
                        String value2 = valueIterator.next();
                        this.cachedContent.write(URLEncoder.encode(name2, requestEncoding).getBytes());
                        if (value2 == null) continue;
                        this.cachedContent.write(61);
                        this.cachedContent.write(URLEncoder.encode(value2, requestEncoding).getBytes());
                        if (!valueIterator.hasNext()) continue;
                        this.cachedContent.write(38);
                    }
                    if (!nameIterator.hasNext()) continue;
                    this.cachedContent.write(38);
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write request parameters to cached content", ex);
        }
    }

    public byte[] getContentAsByteArray() {
        return this.cachedContent.toByteArray();
    }

    public String getContentAsString() {
        return this.cachedContent.toString(Charset.forName(this.getCharacterEncoding()));
    }

    protected void handleContentOverflow(int contentCacheLimit) {
    }

    private class ContentCachingInputStream
    extends ServletInputStream {
        private final ServletInputStream is;
        private boolean overflow = false;

        public ContentCachingInputStream(ServletInputStream is) {
            this.is = is;
        }

        @Override
        public int read() throws IOException {
            int ch = this.is.read();
            if (ch != -1 && !this.overflow) {
                if (ContentCachingRequestWrapper.this.contentCacheLimit != null && ContentCachingRequestWrapper.this.cachedContent.size() == ContentCachingRequestWrapper.this.contentCacheLimit.intValue()) {
                    this.overflow = true;
                    ContentCachingRequestWrapper.this.handleContentOverflow(ContentCachingRequestWrapper.this.contentCacheLimit);
                } else {
                    ContentCachingRequestWrapper.this.cachedContent.write(ch);
                }
            }
            return ch;
        }

        @Override
        public int read(byte[] b2) throws IOException {
            int count2 = this.is.read(b2);
            this.writeToCache(b2, 0, count2);
            return count2;
        }

        private void writeToCache(byte[] b2, int off, int count2) throws IOException {
            if (!this.overflow && count2 > 0) {
                if (ContentCachingRequestWrapper.this.contentCacheLimit != null && count2 + ContentCachingRequestWrapper.this.cachedContent.size() > ContentCachingRequestWrapper.this.contentCacheLimit) {
                    this.overflow = true;
                    ContentCachingRequestWrapper.this.cachedContent.write(b2, off, ContentCachingRequestWrapper.this.contentCacheLimit - ContentCachingRequestWrapper.this.cachedContent.size());
                    ContentCachingRequestWrapper.this.handleContentOverflow(ContentCachingRequestWrapper.this.contentCacheLimit);
                    return;
                }
                ContentCachingRequestWrapper.this.cachedContent.write(b2, off, count2);
            }
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            int count2 = this.is.read(b2, off, len);
            this.writeToCache(b2, off, count2);
            return count2;
        }

        @Override
        public int readLine(byte[] b2, int off, int len) throws IOException {
            int count2 = this.is.readLine(b2, off, len);
            this.writeToCache(b2, off, count2);
            return count2;
        }

        @Override
        public boolean isFinished() {
            return this.is.isFinished();
        }

        @Override
        public boolean isReady() {
            return this.is.isReady();
        }

        @Override
        public void setReadListener(ReadListener readListener) {
            this.is.setReadListener(readListener);
        }
    }
}

