/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.util.ServletRequestPathUtils;

public class DefaultRequestToViewNameTranslator
implements RequestToViewNameTranslator {
    private static final String SLASH = "/";
    private String prefix = "";
    private String suffix = "";
    private String separator = "/";
    private boolean stripLeadingSlash = true;
    private boolean stripTrailingSlash = true;
    private boolean stripExtension = true;

    public void setPrefix(@Nullable String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    public void setSuffix(@Nullable String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setStripLeadingSlash(boolean stripLeadingSlash) {
        this.stripLeadingSlash = stripLeadingSlash;
    }

    public void setStripTrailingSlash(boolean stripTrailingSlash) {
        this.stripTrailingSlash = stripTrailingSlash;
    }

    public void setStripExtension(boolean stripExtension) {
        this.stripExtension = stripExtension;
    }

    @Override
    public String getViewName(HttpServletRequest request) {
        String path2 = ServletRequestPathUtils.getCachedPathValue(request);
        return this.prefix + this.transformPath(path2) + this.suffix;
    }

    @Nullable
    protected String transformPath(String lookupPath) {
        String path2 = lookupPath;
        if (this.stripLeadingSlash && path2.startsWith(SLASH)) {
            path2 = path2.substring(1);
        }
        if (this.stripTrailingSlash && path2.endsWith(SLASH)) {
            path2 = path2.substring(0, path2.length() - 1);
        }
        if (this.stripExtension) {
            path2 = StringUtils.stripFilenameExtension(path2);
        }
        if (!SLASH.equals(this.separator)) {
            path2 = StringUtils.replace(path2, SLASH, this.separator);
        }
        return path2;
    }
}

