/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import jakarta.servlet.jsp.JspException;
import org.springframework.web.servlet.tags.form.AbstractSingleCheckedElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class CheckboxTag
extends AbstractSingleCheckedElementTag {
    @Override
    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        super.writeTagContent(tagWriter);
        if (!this.isDisabled()) {
            tagWriter.startTag("input");
            tagWriter.writeAttribute("type", "hidden");
            String name2 = "_" + this.getName();
            tagWriter.writeAttribute("name", name2);
            tagWriter.writeAttribute("value", this.processFieldValue(name2, "on", "hidden"));
            tagWriter.endTag();
        }
        return 0;
    }

    @Override
    protected void writeTagDetails(TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("type", this.getInputType());
        Object boundValue = this.getBoundValue();
        Class<?> valueType = this.getBindStatus().getValueType();
        if (Boolean.class == valueType || Boolean.TYPE == valueType) {
            if (boundValue instanceof String) {
                String string2 = (String)boundValue;
                boundValue = Boolean.valueOf(string2);
            }
            Boolean booleanValue = boundValue != null ? (Boolean)boundValue : Boolean.FALSE;
            this.renderFromBoolean(booleanValue, tagWriter);
        } else {
            Object value2 = this.getValue();
            if (value2 == null) {
                throw new IllegalArgumentException("Attribute 'value' is required when binding to non-boolean values");
            }
            Object resolvedValue = value2 instanceof String ? this.evaluate("value", value2) : value2;
            this.renderFromValue(resolvedValue, tagWriter);
        }
    }

    @Override
    protected String getInputType() {
        return "checkbox";
    }
}

