/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import jakarta.servlet.jsp.JspException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.tags.form.AbstractCheckedElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractSingleCheckedElementTag
extends AbstractCheckedElementTag {
    @Nullable
    private Object value;
    @Nullable
    private Object label;

    public void setValue(Object value2) {
        this.value = value2;
    }

    @Nullable
    protected Object getValue() {
        return this.value;
    }

    public void setLabel(Object label2) {
        this.label = label2;
    }

    @Nullable
    protected Object getLabel() {
        return this.label;
    }

    @Override
    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        String id2 = this.resolveId();
        this.writeOptionalAttribute(tagWriter, "id", id2);
        this.writeOptionalAttribute(tagWriter, "name", this.getName());
        this.writeOptionalAttributes(tagWriter);
        this.writeTagDetails(tagWriter);
        tagWriter.endTag();
        Object resolvedLabel = this.evaluate("label", this.getLabel());
        if (resolvedLabel != null) {
            Assert.state(id2 != null, "Label id is required");
            tagWriter.startTag("label");
            tagWriter.writeAttribute("for", id2);
            tagWriter.appendValue(this.convertToDisplayString(resolvedLabel));
            tagWriter.endTag();
        }
        return 0;
    }

    protected abstract void writeTagDetails(TagWriter var1) throws JspException;
}

