/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import java.beans.PropertyEditor;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestDataValueProcessor;
import org.springframework.web.servlet.tags.EditorAwareTag;
import org.springframework.web.servlet.tags.form.AbstractFormTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractDataBoundFormElementTag
extends AbstractFormTag
implements EditorAwareTag {
    protected static final String NESTED_PATH_VARIABLE_NAME = "nestedPath";
    @Nullable
    private String path;
    @Nullable
    private String id;
    @Nullable
    private BindStatus bindStatus;

    public void setPath(String path2) {
        this.path = path2;
    }

    protected final String getPath() throws JspException {
        String resolvedPath = (String)this.evaluate("path", this.path);
        return resolvedPath != null ? resolvedPath : "";
    }

    public void setId(@Nullable String id2) {
        this.id = id2;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    protected void writeDefaultAttributes(TagWriter tagWriter) throws JspException {
        this.writeOptionalAttribute(tagWriter, "id", this.resolveId());
        this.writeOptionalAttribute(tagWriter, "name", this.getName());
    }

    @Nullable
    protected String resolveId() throws JspException {
        Object id2 = this.evaluate("id", this.getId());
        if (id2 != null) {
            String idString = id2.toString();
            return StringUtils.hasText(idString) ? idString : null;
        }
        return this.autogenerateId();
    }

    @Nullable
    protected String autogenerateId() throws JspException {
        String name2 = this.getName();
        return name2 != null ? StringUtils.deleteAny(name2, "[]") : null;
    }

    @Nullable
    protected String getName() throws JspException {
        return this.getPropertyPath();
    }

    protected BindStatus getBindStatus() throws JspException {
        if (this.bindStatus == null) {
            String pathToUse;
            String nestedPath = this.getNestedPath();
            String string2 = pathToUse = nestedPath != null ? nestedPath + this.getPath() : this.getPath();
            if (pathToUse.endsWith(".")) {
                pathToUse = pathToUse.substring(0, pathToUse.length() - 1);
            }
            this.bindStatus = new BindStatus(this.getRequestContext(), pathToUse, false);
        }
        return this.bindStatus;
    }

    @Nullable
    protected String getNestedPath() {
        return (String)this.pageContext.getAttribute(NESTED_PATH_VARIABLE_NAME, 2);
    }

    protected String getPropertyPath() throws JspException {
        String expression = this.getBindStatus().getExpression();
        return expression != null ? expression : "";
    }

    @Nullable
    protected final Object getBoundValue() throws JspException {
        return this.getBindStatus().getValue();
    }

    @Nullable
    protected PropertyEditor getPropertyEditor() throws JspException {
        return this.getBindStatus().getEditor();
    }

    @Override
    @Nullable
    public final PropertyEditor getEditor() throws JspException {
        return this.getPropertyEditor();
    }

    protected String convertToDisplayString(@Nullable Object value2) throws JspException {
        PropertyEditor editor = value2 != null ? this.getBindStatus().findEditor(value2.getClass()) : null;
        return this.getDisplayString(value2, editor);
    }

    protected final String processFieldValue(@Nullable String name2, String value2, String type2) {
        RequestDataValueProcessor processor = this.getRequestContext().getRequestDataValueProcessor();
        ServletRequest request = this.pageContext.getRequest();
        if (processor != null && request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            value2 = processor.processFormFieldValue(httpServletRequest, name2, value2, type2);
        }
        return value2;
    }

    @Override
    public void doFinally() {
        super.doFinally();
        this.bindStatus = null;
    }
}

