/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.tags.EditorAwareTag;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.TagUtils;

public class TransformTag
extends HtmlEscapingAwareTag {
    @Nullable
    private Object value;
    @Nullable
    private String var;
    private String scope = "page";

    public void setValue(Object value2) {
        this.value = value2;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    protected final int doStartTagInternal() throws JspException {
        if (this.value != null) {
            EditorAwareTag tag2 = (EditorAwareTag)TagSupport.findAncestorWithClass((Tag)this, EditorAwareTag.class);
            if (tag2 == null) {
                throw new JspException("TransformTag can only be used within EditorAwareTag (e.g. BindTag)");
            }
            String result2 = null;
            PropertyEditor editor = tag2.getEditor();
            if (editor != null) {
                editor.setValue(this.value);
                result2 = editor.getAsText();
            } else {
                result2 = this.value.toString();
            }
            result2 = this.htmlEscape(result2);
            if (this.var != null) {
                this.pageContext.setAttribute(this.var, (Object)result2, TagUtils.getScope(this.scope));
            } else {
                try {
                    this.pageContext.getOut().print(result2);
                }
                catch (IOException ex) {
                    throw new JspException((Throwable)ex);
                }
            }
        }
        return 0;
    }
}

