/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.Tag;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.tags.Param;
import org.springframework.web.servlet.tags.ParamAware;

public class ParamTag
extends BodyTagSupport {
    private String name = "";
    @Nullable
    private String value;
    private boolean valueSet;

    public void setName(String name2) {
        this.name = name2;
    }

    public void setValue(String value2) {
        this.value = value2;
        this.valueSet = true;
    }

    public int doEndTag() throws JspException {
        Param param = new Param();
        param.setName(this.name);
        if (this.valueSet) {
            param.setValue(this.value);
        } else if (this.getBodyContent() != null) {
            param.setValue(this.getBodyContent().getString().trim());
        }
        ParamAware paramAwareTag = (ParamAware)ParamTag.findAncestorWithClass((Tag)this, ParamAware.class);
        if (paramAwareTag == null) {
            throw new JspException("The param tag must be a descendant of a tag that supports parameters");
        }
        paramAwareTag.addParam(param);
        return 6;
    }

    public void release() {
        super.release();
        this.name = "";
        this.value = null;
        this.valueSet = false;
    }
}

