/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import org.springframework.lang.Nullable;

public class NestedPathTag
extends TagSupport
implements TryCatchFinally {
    public static final String NESTED_PATH_VARIABLE_NAME = "nestedPath";
    @Nullable
    private String path;
    @Nullable
    private String previousNestedPath;

    public void setPath(@Nullable String path2) {
        if (path2 == null) {
            path2 = "";
        }
        if (((String)path2).length() > 0 && !((String)path2).endsWith(".")) {
            path2 = (String)path2 + ".";
        }
        this.path = path2;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public int doStartTag() throws JspException {
        this.previousNestedPath = (String)this.pageContext.getAttribute(NESTED_PATH_VARIABLE_NAME, 2);
        String nestedPath = this.previousNestedPath != null ? this.previousNestedPath + this.getPath() : this.getPath();
        this.pageContext.setAttribute(NESTED_PATH_VARIABLE_NAME, (Object)nestedPath, 2);
        return 1;
    }

    public int doEndTag() {
        if (this.previousNestedPath != null) {
            this.pageContext.setAttribute(NESTED_PATH_VARIABLE_NAME, (Object)this.previousNestedPath, 2);
        } else {
            this.pageContext.removeAttribute(NESTED_PATH_VARIABLE_NAME, 2);
        }
        return 6;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        this.previousNestedPath = null;
    }
}

