/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.webjars.WebJarAssetLocator;

public class WebJarsResourceResolver
extends AbstractResourceResolver {
    private static final String WEBJARS_LOCATION = "META-INF/resources/webjars/";
    private static final int WEBJARS_LOCATION_LENGTH = "META-INF/resources/webjars/".length();
    private final WebJarAssetLocator webJarAssetLocator;

    public WebJarsResourceResolver() {
        this(new WebJarAssetLocator());
    }

    public WebJarsResourceResolver(WebJarAssetLocator webJarAssetLocator) {
        this.webJarAssetLocator = webJarAssetLocator;
    }

    @Override
    @Nullable
    protected Resource resolveResourceInternal(@Nullable HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain2) {
        String webJarResourcePath;
        Resource resolved = chain2.resolveResource(request, requestPath, locations);
        if (resolved == null && (webJarResourcePath = this.findWebJarResourcePath(requestPath)) != null) {
            return chain2.resolveResource(request, webJarResourcePath, locations);
        }
        return resolved;
    }

    @Override
    @Nullable
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain2) {
        String webJarResourcePath;
        String path2 = chain2.resolveUrlPath(resourceUrlPath, locations);
        if (path2 == null && (webJarResourcePath = this.findWebJarResourcePath(resourceUrlPath)) != null) {
            return chain2.resolveUrlPath(webJarResourcePath, locations);
        }
        return path2;
    }

    @Nullable
    protected String findWebJarResourcePath(String path2) {
        String partialPath;
        String webjar;
        String webJarPath;
        int startOffset = path2.startsWith("/") ? 1 : 0;
        int endOffset = path2.indexOf(47, 1);
        if (endOffset != -1 && (webJarPath = this.webJarAssetLocator.getFullPathExact(webjar = path2.substring(startOffset, endOffset), partialPath = path2.substring(endOffset + 1))) != null) {
            return webJarPath.substring(WEBJARS_LOCATION_LENGTH);
        }
        return null;
    }
}

