/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;

class DefaultResourceTransformerChain
implements ResourceTransformerChain {
    private final ResourceResolverChain resolverChain;
    @Nullable
    private final ResourceTransformer transformer;
    @Nullable
    private final ResourceTransformerChain nextChain;

    public DefaultResourceTransformerChain(ResourceResolverChain resolverChain, @Nullable List<ResourceTransformer> transformers) {
        Assert.notNull((Object)resolverChain, "ResourceResolverChain is required");
        this.resolverChain = resolverChain;
        transformers = transformers != null ? transformers : Collections.emptyList();
        DefaultResourceTransformerChain chain2 = this.initTransformerChain(resolverChain, new ArrayList<ResourceTransformer>(transformers));
        this.transformer = chain2.transformer;
        this.nextChain = chain2.nextChain;
    }

    private DefaultResourceTransformerChain initTransformerChain(ResourceResolverChain resolverChain, ArrayList<ResourceTransformer> transformers) {
        DefaultResourceTransformerChain chain2 = new DefaultResourceTransformerChain(resolverChain, null, null);
        ListIterator<ResourceTransformer> it = transformers.listIterator(transformers.size());
        while (it.hasPrevious()) {
            chain2 = new DefaultResourceTransformerChain(resolverChain, it.previous(), chain2);
        }
        return chain2;
    }

    public DefaultResourceTransformerChain(ResourceResolverChain resolverChain, @Nullable ResourceTransformer transformer, @Nullable ResourceTransformerChain chain2) {
        Assert.isTrue(transformer == null && chain2 == null || transformer != null && chain2 != null, "Both transformer and transformer chain must be null, or neither is");
        this.resolverChain = resolverChain;
        this.transformer = transformer;
        this.nextChain = chain2;
    }

    @Override
    public ResourceResolverChain getResolverChain() {
        return this.resolverChain;
    }

    @Override
    public Resource transform(HttpServletRequest request, Resource resource) throws IOException {
        return this.transformer != null && this.nextChain != null ? this.transformer.transform(request, resource, this.nextChain) : resource;
    }
}

