/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.EncodedResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.ResourceTransformerSupport;
import org.springframework.web.servlet.resource.TransformedResource;

public class CssLinkResourceTransformer
extends ResourceTransformerSupport {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Log logger = LogFactory.getLog(CssLinkResourceTransformer.class);
    private final List<LinkParser> linkParsers = new ArrayList<LinkParser>(2);

    public CssLinkResourceTransformer() {
        this.linkParsers.add(new ImportStatementLinkParser());
        this.linkParsers.add(new UrlFunctionLinkParser());
    }

    @Override
    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        String filename2 = (resource = transformerChain.transform(request, resource)).getFilename();
        if (!"css".equals(StringUtils.getFilenameExtension(filename2)) || resource instanceof EncodedResourceResolver.EncodedResource) {
            return resource;
        }
        byte[] bytes2 = FileCopyUtils.copyToByteArray(resource.getInputStream());
        String content = new String(bytes2, DEFAULT_CHARSET);
        TreeSet<ContentChunkInfo> links = new TreeSet<ContentChunkInfo>();
        for (LinkParser parser : this.linkParsers) {
            parser.parse(content, links);
        }
        if (links.isEmpty()) {
            return resource;
        }
        int index2 = 0;
        StringWriter writer = new StringWriter();
        for (ContentChunkInfo linkContentChunkInfo : links) {
            writer.write(content.substring(index2, linkContentChunkInfo.getStart()));
            String link2 = content.substring(linkContentChunkInfo.getStart(), linkContentChunkInfo.getEnd());
            String newLink = null;
            if (!this.hasScheme(link2)) {
                String absolutePath = this.toAbsolutePath(link2, request);
                newLink = this.resolveUrlPath(absolutePath, request, resource, transformerChain);
            }
            writer.write(newLink != null ? newLink : link2);
            index2 = linkContentChunkInfo.getEnd();
        }
        writer.write(content.substring(index2));
        return new TransformedResource(resource, writer.toString().getBytes(DEFAULT_CHARSET));
    }

    private boolean hasScheme(String link2) {
        int schemeIndex = link2.indexOf(58);
        return schemeIndex > 0 && !link2.substring(0, schemeIndex).contains("/") || link2.indexOf("//") == 0;
    }

    private static class ImportStatementLinkParser
    extends AbstractLinkParser {
        private ImportStatementLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "@import";
        }

        @Override
        protected int extractLink(int index2, String content, SortedSet<ContentChunkInfo> linksToAdd) {
            if (!content.startsWith("url(", index2) && logger.isTraceEnabled()) {
                logger.trace("Unexpected syntax for @import link at index " + index2);
            }
            return index2;
        }
    }

    private static class UrlFunctionLinkParser
    extends AbstractLinkParser {
        private UrlFunctionLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "url(";
        }

        @Override
        protected int extractLink(int index2, String content, SortedSet<ContentChunkInfo> linksToAdd) {
            return this.extractLink(index2 - 1, ")", content, linksToAdd);
        }
    }

    @FunctionalInterface
    protected static interface LinkParser {
        public void parse(String var1, SortedSet<ContentChunkInfo> var2);
    }

    private static class ContentChunkInfo
    implements Comparable<ContentChunkInfo> {
        private final int start;
        private final int end;

        ContentChunkInfo(int start2, int end2) {
            this.start = start2;
            this.end = end2;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @Override
        public int compareTo(ContentChunkInfo other) {
            return Integer.compare(this.start, other.start);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof ContentChunkInfo)) return false;
            ContentChunkInfo that = (ContentChunkInfo)other;
            if (this.start != that.start) return false;
            if (this.end != that.end) return false;
            return true;
        }

        public int hashCode() {
            return this.start * 31 + this.end;
        }
    }

    protected static abstract class AbstractLinkParser
    implements LinkParser {
        protected AbstractLinkParser() {
        }

        protected abstract String getKeyword();

        @Override
        public void parse(String content, SortedSet<ContentChunkInfo> result2) {
            int position = 0;
            while ((position = content.indexOf(this.getKeyword(), position)) != -1) {
                position += this.getKeyword().length();
                while (Character.isWhitespace(content.charAt(position))) {
                    ++position;
                }
                if (content.charAt(position) == '\'') {
                    position = this.extractLink(position, "'", content, result2);
                    continue;
                }
                if (content.charAt(position) == '\"') {
                    position = this.extractLink(position, "\"", content, result2);
                    continue;
                }
                position = this.extractLink(position, content, result2);
            }
            return;
        }

        protected int extractLink(int index2, String endKey, String content, SortedSet<ContentChunkInfo> linksToAdd) {
            int start2 = index2 + 1;
            int end2 = content.indexOf(endKey, start2);
            linksToAdd.add(new ContentChunkInfo(start2, end2));
            return end2 + endKey.length();
        }

        protected abstract int extractLink(int var1, String var2, SortedSet<ContentChunkInfo> var3);
    }
}

