/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotatedMethod;
import org.springframework.lang.Nullable;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.SpringObjenesis;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.CompositeUriComponentsContributor;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.pattern.PathPatternParser;

public class MvcUriComponentsBuilder {
    public static final String MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME = "mvcUriComponentsContributor";
    private static final Log logger = LogFactory.getLog(MvcUriComponentsBuilder.class);
    private static final SpringObjenesis objenesis = new SpringObjenesis();
    private static final PathMatcher pathMatcher = new AntPathMatcher();
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private static final CompositeUriComponentsContributor defaultUriComponentsContributor = new CompositeUriComponentsContributor(new PathVariableMethodArgumentResolver(), new RequestParamMethodArgumentResolver(false));
    private final UriComponentsBuilder baseUrl;

    protected MvcUriComponentsBuilder(UriComponentsBuilder baseUrl) {
        Assert.notNull((Object)baseUrl, "'baseUrl' is required");
        this.baseUrl = baseUrl;
    }

    public static MvcUriComponentsBuilder relativeTo(UriComponentsBuilder baseUrl) {
        return new MvcUriComponentsBuilder(baseUrl);
    }

    public static UriComponentsBuilder fromController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(null, controllerType);
    }

    public static UriComponentsBuilder fromController(@Nullable UriComponentsBuilder builder, Class<?> controllerType) {
        builder = MvcUriComponentsBuilder.getBaseUrlToUse(builder);
        String prefix = MvcUriComponentsBuilder.getPathPrefix(controllerType);
        builder.path(prefix);
        String mapping = MvcUriComponentsBuilder.getClassMapping(controllerType);
        mapping = !StringUtils.hasText(prefix + mapping) ? "/" : mapping;
        builder.path(mapping);
        return builder;
    }

    public static UriComponentsBuilder fromMethodName(Class<?> controllerType, String methodName, Object ... args2) {
        Method method2 = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args2);
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method2, args2);
    }

    public static UriComponentsBuilder fromMethodName(UriComponentsBuilder builder, Class<?> controllerType, String methodName, Object ... args2) {
        Method method2 = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args2);
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method2, args2);
    }

    public static UriComponentsBuilder fromMethod(Class<?> controllerType, Method method2, Object ... args2) {
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method2, args2);
    }

    public static UriComponentsBuilder fromMethod(UriComponentsBuilder baseUrl, @Nullable Class<?> controllerType, Method method2, Object ... args2) {
        return MvcUriComponentsBuilder.fromMethodInternal(baseUrl, controllerType != null ? controllerType : method2.getDeclaringClass(), method2, args2);
    }

    public static UriComponentsBuilder fromMethodCall(Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, info, "MethodInvocationInfo required");
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method2 = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method2, arguments);
    }

    public static UriComponentsBuilder fromMethodCall(UriComponentsBuilder builder, Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, info, "MethodInvocationInfo required");
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method2 = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method2, arguments);
    }

    public static <T> T on(Class<T> controllerType) {
        return MvcUriComponentsBuilder.controller(controllerType);
    }

    public static <T> T controller(Class<T> controllerType) {
        Assert.notNull(controllerType, "'controllerType' must not be null");
        return ControllerMethodInvocationInterceptor.initProxy(controllerType, null);
    }

    public static MethodArgumentBuilder fromMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(null, mappingName);
    }

    public static MethodArgumentBuilder fromMappingName(@Nullable UriComponentsBuilder builder, String name2) {
        RequestMappingInfoHandlerMapping mapping;
        WebApplicationContext wac = MvcUriComponentsBuilder.getWebApplicationContext();
        Assert.state(wac != null, "No WebApplicationContext");
        Map<String, RequestMappingInfoHandlerMapping> map2 = wac.getBeansOfType(RequestMappingInfoHandlerMapping.class);
        List<HandlerMethod> handlerMethods = null;
        Iterator<RequestMappingInfoHandlerMapping> iterator = map2.values().iterator();
        while (iterator.hasNext() && (handlerMethods = (mapping = iterator.next()).getHandlerMethodsForMappingName(name2)) == null) {
        }
        if (handlerMethods == null) {
            throw new IllegalArgumentException("Mapping not found: " + name2);
        }
        if (handlerMethods.size() != 1) {
            throw new IllegalArgumentException("No unique match for mapping " + name2 + ": " + handlerMethods);
        }
        HandlerMethod handlerMethod = handlerMethods.get(0);
        Class<?> controllerType = handlerMethod.getBeanType();
        Method method2 = handlerMethod.getMethod();
        return new MethodArgumentBuilder(builder, controllerType, method2);
    }

    public UriComponentsBuilder withController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(this.baseUrl, controllerType);
    }

    public UriComponentsBuilder withMethodName(Class<?> controllerType, String methodName, Object ... args2) {
        return MvcUriComponentsBuilder.fromMethodName(this.baseUrl, controllerType, methodName, args2);
    }

    public UriComponentsBuilder withMethodCall(Object invocationInfo) {
        return MvcUriComponentsBuilder.fromMethodCall(this.baseUrl, invocationInfo);
    }

    public MethodArgumentBuilder withMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(this.baseUrl, mappingName);
    }

    public UriComponentsBuilder withMethod(Class<?> controllerType, Method method2, Object ... args2) {
        return MvcUriComponentsBuilder.fromMethod(this.baseUrl, controllerType, method2, args2);
    }

    private static UriComponentsBuilder fromMethodInternal(@Nullable UriComponentsBuilder builder, Class<?> controllerType, Method method2, Object ... args2) {
        AnnotatedMethod annotatedMethod = new AnnotatedMethod(method2);
        builder = MvcUriComponentsBuilder.getBaseUrlToUse(builder);
        String prefix = MvcUriComponentsBuilder.getPathPrefix(controllerType);
        builder.path(prefix);
        String typePath = MvcUriComponentsBuilder.getClassMapping(controllerType);
        String methodPath = MvcUriComponentsBuilder.getMethodMapping(annotatedMethod);
        String path2 = pathMatcher.combine(typePath, methodPath);
        path2 = PathPatternParser.defaultInstance.initFullPathPattern(path2);
        if (!StringUtils.hasText(prefix + path2)) {
            path2 = "/";
        }
        builder.path(path2);
        return MvcUriComponentsBuilder.applyContributors(builder, annotatedMethod, args2);
    }

    private static UriComponentsBuilder getBaseUrlToUse(@Nullable UriComponentsBuilder baseUrl) {
        return baseUrl == null ? ServletUriComponentsBuilder.fromCurrentServletMapping() : baseUrl.cloneBuilder();
    }

    private static String getPathPrefix(Class<?> controllerType) {
        WebApplicationContext wac = MvcUriComponentsBuilder.getWebApplicationContext();
        if (wac != null) {
            Map<String, RequestMappingHandlerMapping> map2 = wac.getBeansOfType(RequestMappingHandlerMapping.class);
            for (RequestMappingHandlerMapping mapping : map2.values()) {
                String prefix;
                if (!mapping.isHandler(controllerType) || (prefix = mapping.getPathPrefix(controllerType)) == null) continue;
                return prefix;
            }
        }
        return "";
    }

    private static String getClassMapping(Class<?> controllerType) {
        Assert.notNull(controllerType, "'controllerType' must not be null");
        RequestMapping mapping = AnnotatedElementUtils.findMergedAnnotation(controllerType, RequestMapping.class);
        if (mapping == null) {
            return "";
        }
        return MvcUriComponentsBuilder.getPathMapping(mapping, controllerType.getName());
    }

    private static String getMethodMapping(AnnotatedMethod annotatedMethod) {
        RequestMapping requestMapping = annotatedMethod.getMethodAnnotation(RequestMapping.class);
        if (requestMapping == null) {
            throw new IllegalArgumentException("No @RequestMapping on: " + annotatedMethod.getMethod().toGenericString());
        }
        return MvcUriComponentsBuilder.getPathMapping(requestMapping, annotatedMethod.getMethod().toGenericString());
    }

    private static String getPathMapping(RequestMapping requestMapping, String source2) {
        Object[] paths = requestMapping.path();
        if (ObjectUtils.isEmpty(paths) || !StringUtils.hasLength((String)paths[0])) {
            return "";
        }
        if (paths.length > 1 && logger.isTraceEnabled()) {
            logger.trace("Using first of multiple paths on " + source2);
        }
        return MvcUriComponentsBuilder.resolveEmbeddedValue((String)paths[0]);
    }

    private static Method getMethod(Class<?> controllerType, String methodName, Object ... args2) {
        ReflectionUtils.MethodFilter selector = method2 -> {
            String name2 = method2.getName();
            int argLength = method2.getParameterCount();
            return name2.equals(methodName) && argLength == args2.length;
        };
        Set<Method> methods2 = MethodIntrospector.selectMethods(controllerType, selector);
        if (methods2.size() == 1) {
            return methods2.iterator().next();
        }
        if (methods2.size() > 1) {
            throw new IllegalArgumentException(String.format("Found two methods named '%s' accepting arguments %s in controller %s: [%s]", methodName, Arrays.asList(args2), controllerType.getName(), methods2));
        }
        throw new IllegalArgumentException("No method named '" + methodName + "' with " + args2.length + " arguments found in controller " + controllerType.getName());
    }

    private static UriComponentsBuilder applyContributors(UriComponentsBuilder builder, AnnotatedMethod annotatedMethod, Object ... args2) {
        int argCount;
        CompositeUriComponentsContributor contributor = MvcUriComponentsBuilder.getUriComponentsContributor();
        int paramCount = annotatedMethod.getMethodParameters().length;
        if (paramCount != (argCount = args2.length)) {
            throw new IllegalArgumentException("Number of method parameters " + paramCount + " does not match number of argument values " + argCount);
        }
        HashMap<String, Object> uriVars = new HashMap<String, Object>();
        for (int i2 = 0; i2 < paramCount; ++i2) {
            MethodParameter param = annotatedMethod.getMethodParameters()[i2];
            param.initParameterNameDiscovery(parameterNameDiscoverer);
            contributor.contributeMethodArgument(param, args2[i2], builder, uriVars);
        }
        return builder.uriVariables(uriVars);
    }

    private static CompositeUriComponentsContributor getUriComponentsContributor() {
        WebApplicationContext wac = MvcUriComponentsBuilder.getWebApplicationContext();
        if (wac != null) {
            try {
                return wac.getBean(MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME, CompositeUriComponentsContributor.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return defaultUriComponentsContributor;
    }

    private static String resolveEmbeddedValue(String value2) {
        ConfigurableBeanFactory cbf;
        String resolvedEmbeddedValue;
        AutowireCapableBeanFactory autowireCapableBeanFactory;
        WebApplicationContext webApplicationContext;
        if (value2.contains("${") && (webApplicationContext = MvcUriComponentsBuilder.getWebApplicationContext()) != null && (autowireCapableBeanFactory = webApplicationContext.getAutowireCapableBeanFactory()) instanceof ConfigurableBeanFactory && (resolvedEmbeddedValue = (cbf = (ConfigurableBeanFactory)((Object)autowireCapableBeanFactory)).resolveEmbeddedValue(value2)) != null) {
            return resolvedEmbeddedValue;
        }
        return value2;
    }

    @Nullable
    private static WebApplicationContext getWebApplicationContext() {
        String attributeName;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        WebApplicationContext wac = (WebApplicationContext)request.getAttribute(attributeName = DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (wac == null) {
            return null;
        }
        return wac;
    }

    public static interface MethodInvocationInfo {
        public Class<?> getControllerType();

        public Method getControllerMethod();

        public Object[] getArgumentValues();
    }

    private static class ControllerMethodInvocationInterceptor
    implements MethodInterceptor,
    InvocationHandler,
    MethodInvocationInfo {
        private final Class<?> controllerType;
        @Nullable
        private Method controllerMethod;
        @Nullable
        private Object[] argumentValues;

        ControllerMethodInvocationInterceptor(Class<?> controllerType) {
            this.controllerType = controllerType;
        }

        @Override
        @Nullable
        public Object intercept(@Nullable Object obj, Method method2, Object[] args2, @Nullable MethodProxy proxy2) {
            switch (method2.getName()) {
                case "getControllerType": {
                    return this.controllerType;
                }
                case "getControllerMethod": {
                    return this.controllerMethod;
                }
                case "getArgumentValues": {
                    return this.argumentValues;
                }
            }
            if (ReflectionUtils.isObjectMethod(method2)) {
                return ReflectionUtils.invokeMethod(method2, obj, args2);
            }
            this.controllerMethod = method2;
            this.argumentValues = args2;
            Class<?> returnType = method2.getReturnType();
            try {
                return returnType == Void.TYPE ? null : returnType.cast(ControllerMethodInvocationInterceptor.initProxy(returnType, this));
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to create proxy for controller method return type: " + method2, ex);
            }
        }

        @Override
        @Nullable
        public Object invoke(Object proxy2, Method method2, @Nullable Object[] args2) {
            return this.intercept(proxy2, method2, args2 != null ? args2 : new Object[]{}, null);
        }

        @Override
        public Class<?> getControllerType() {
            return this.controllerType;
        }

        @Override
        public Method getControllerMethod() {
            Assert.state(this.controllerMethod != null, "Not initialized yet");
            return this.controllerMethod;
        }

        @Override
        public Object[] getArgumentValues() {
            Assert.state(this.argumentValues != null, "Not initialized yet");
            return this.argumentValues;
        }

        private static <T> T initProxy(Class<?> controllerType, @Nullable ControllerMethodInvocationInterceptor interceptor) {
            ControllerMethodInvocationInterceptor controllerMethodInvocationInterceptor = interceptor = interceptor != null ? interceptor : new ControllerMethodInvocationInterceptor(controllerType);
            if (controllerType == Object.class) {
                return (T)interceptor;
            }
            if (controllerType.isInterface()) {
                ClassLoader classLoader = controllerType.getClassLoader();
                if (classLoader == null) {
                    classLoader = MethodInvocationInfo.class.getClassLoader();
                } else if (classLoader.getParent() == null) {
                    ClassLoader miiClassLoader = MethodInvocationInfo.class.getClassLoader();
                    for (ClassLoader miiParent = miiClassLoader.getParent(); miiParent != null; miiParent = miiParent.getParent()) {
                        if (classLoader != miiParent) continue;
                        classLoader = miiClassLoader;
                        break;
                    }
                }
                Class[] ifcs = new Class[]{controllerType, MethodInvocationInfo.class};
                return (T)Proxy.newProxyInstance(classLoader, ifcs, (InvocationHandler)interceptor);
            }
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(controllerType);
            enhancer.setInterfaces(new Class[]{MethodInvocationInfo.class});
            enhancer.setNamingPolicy(SpringNamingPolicy.INSTANCE);
            enhancer.setAttemptLoad(true);
            enhancer.setCallbackType(MethodInterceptor.class);
            Class proxyClass = enhancer.createClass();
            T proxy2 = null;
            if (objenesis.isWorthTrying()) {
                try {
                    proxy2 = objenesis.newInstance(proxyClass, enhancer.getUseCache());
                }
                catch (ObjenesisException ex) {
                    logger.debug("Failed to create controller proxy, falling back on default constructor", ex);
                }
            }
            if (proxy2 == null) {
                try {
                    proxy2 = ReflectionUtils.accessibleConstructor(proxyClass, new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to create controller proxy or use default constructor", ex);
                }
            }
            ((Factory)proxy2).setCallbacks(new Callback[]{interceptor});
            return proxy2;
        }
    }

    public static class MethodArgumentBuilder {
        private final Class<?> controllerType;
        private final Method method;
        private final Object[] argumentValues;
        private final UriComponentsBuilder baseUrl;

        public MethodArgumentBuilder(Class<?> controllerType, Method method2) {
            this(null, controllerType, method2);
        }

        public MethodArgumentBuilder(@Nullable UriComponentsBuilder baseUrl, Class<?> controllerType, Method method2) {
            Assert.notNull(controllerType, "'controllerType' is required");
            Assert.notNull((Object)method2, "'method' is required");
            this.baseUrl = baseUrl != null ? baseUrl : UriComponentsBuilder.fromPath(MethodArgumentBuilder.getPath());
            this.controllerType = controllerType;
            this.method = method2;
            this.argumentValues = new Object[method2.getParameterCount()];
        }

        private static String getPath() {
            ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentServletMapping();
            String path2 = builder.build().getPath();
            return path2 != null ? path2 : "";
        }

        public MethodArgumentBuilder arg(int index2, Object value2) {
            this.argumentValues[index2] = value2;
            return this;
        }

        public MethodArgumentBuilder encode() {
            this.baseUrl.encode();
            return this;
        }

        public String build() {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).build().encode().toUriString();
        }

        public String buildAndExpand(Object ... uriVars) {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).buildAndExpand(uriVars).encode().toString();
        }
    }
}

