/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.ServletRequest;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.servlet.HandlerMapping;

public class ExtendedServletRequestDataBinder
extends ServletRequestDataBinder {
    public ExtendedServletRequestDataBinder(@Nullable Object target2) {
        super(target2);
    }

    public ExtendedServletRequestDataBinder(@Nullable Object target2, String objectName) {
        super(target2, objectName);
    }

    @Override
    protected ServletRequestDataBinder.ServletRequestValueResolver createValueResolver(ServletRequest request) {
        return new ExtendedServletRequestValueResolver(request, this);
    }

    @Override
    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
        Map<String, String> uriVars = ExtendedServletRequestDataBinder.getUriVars(request);
        if (uriVars != null) {
            uriVars.forEach((name2, value2) -> {
                if (mpvs.contains((String)name2)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("URI variable '" + name2 + "' overridden by request bind value.");
                    }
                } else {
                    mpvs.addPropertyValue((String)name2, value2);
                }
            });
        }
    }

    @Nullable
    private static Map<String, String> getUriVars(ServletRequest request) {
        String attr2 = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
        return (Map)request.getAttribute(attr2);
    }

    private static class ExtendedServletRequestValueResolver
    extends ServletRequestDataBinder.ServletRequestValueResolver {
        ExtendedServletRequestValueResolver(ServletRequest request, WebDataBinder dataBinder) {
            super(request, dataBinder);
        }

        @Override
        @Nullable
        protected Object getRequestParameter(String name2, Class<?> type2) {
            Map<String, String> uriVars;
            Object value2 = super.getRequestParameter(name2, type2);
            if (value2 == null && (uriVars = ExtendedServletRequestDataBinder.getUriVars(this.getRequest())) != null) {
                value2 = uriVars.get(name2);
            }
            return value2;
        }

        @Override
        protected Set<String> initParameterNames(ServletRequest request) {
            Set<String> set2 = super.initParameterNames(request);
            Map<String, String> uriVars = ExtendedServletRequestDataBinder.getUriVars(this.getRequest());
            if (uriVars != null) {
                set2.addAll(uriVars.keySet());
            }
            return set2;
        }
    }
}

