/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DeferredResultMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        Class<?> type2 = returnType.getParameterType();
        return DeferredResult.class.isAssignableFrom(type2) || ListenableFuture.class.isAssignableFrom(type2) || CompletionStage.class.isAssignableFrom(type2);
    }

    @Override
    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        DeferredResult<Object> result2;
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        if (returnValue instanceof DeferredResult) {
            DeferredResult<Object> deferredResult;
            result2 = deferredResult = (DeferredResult<Object>)returnValue;
        } else if (returnValue instanceof ListenableFuture) {
            ListenableFuture listenableFuture = (ListenableFuture)returnValue;
            result2 = this.adaptListenableFuture(listenableFuture);
        } else if (returnValue instanceof CompletionStage) {
            CompletionStage completionStage = (CompletionStage)returnValue;
            result2 = this.adaptCompletionStage(completionStage);
        } else {
            throw new IllegalStateException("Unexpected return value type: " + returnValue);
        }
        WebAsyncUtils.getAsyncManager(webRequest).startDeferredResultProcessing(result2, mavContainer);
    }

    private DeferredResult<Object> adaptListenableFuture(ListenableFuture<?> future) {
        final DeferredResult<Object> result2 = new DeferredResult<Object>();
        future.addCallback(new ListenableFutureCallback<Object>(){

            @Override
            public void onSuccess(@Nullable Object value2) {
                result2.setResult(value2);
            }

            @Override
            public void onFailure(Throwable ex) {
                result2.setErrorResult(ex);
            }
        });
        return result2;
    }

    private DeferredResult<Object> adaptCompletionStage(CompletionStage<?> future) {
        DeferredResult<Object> result2 = new DeferredResult<Object>();
        future.whenComplete((value2, ex) -> {
            if (ex != null) {
                if (ex instanceof CompletionException && ex.getCause() != null) {
                    ex = ex.getCause();
                }
                result2.setErrorResult(ex);
            } else {
                result2.setResult(value2);
            }
        });
        return result2;
    }
}

