/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.ServerHttpObservationFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMethodMappingNamingStrategy;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.WebUtils;
import org.springframework.web.util.pattern.PathPattern;

public abstract class RequestMappingInfoHandlerMapping
extends AbstractHandlerMethodMapping<RequestMappingInfo> {
    private static final Method HTTP_OPTIONS_HANDLE_METHOD;

    protected RequestMappingInfoHandlerMapping() {
        this.setHandlerMethodMappingNamingStrategy(new RequestMappingInfoHandlerMethodMappingNamingStrategy());
    }

    @Override
    protected Set<String> getMappingPathPatterns(RequestMappingInfo info) {
        return info.getPatternValues();
    }

    @Override
    protected Set<String> getDirectPaths(RequestMappingInfo info) {
        return info.getDirectPaths();
    }

    @Override
    @Nullable
    protected RequestMappingInfo getMatchingMapping(RequestMappingInfo info, HttpServletRequest request) {
        return info.getMatchingCondition(request);
    }

    @Override
    protected Comparator<RequestMappingInfo> getMappingComparator(HttpServletRequest request) {
        return (info1, info2) -> info1.compareTo((RequestMappingInfo)info2, request);
    }

    @Override
    @Nullable
    protected HandlerMethod getHandlerInternal(HttpServletRequest request) throws Exception {
        request.removeAttribute(PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        try {
            HandlerMethod handlerMethod = super.getHandlerInternal(request);
            return handlerMethod;
        }
        finally {
            ProducesRequestCondition.clearMediaTypesAttribute(request);
        }
    }

    @Override
    protected void handleMatch(RequestMappingInfo info, String lookupPath, HttpServletRequest request) {
        Set<MediaType> mediaTypes;
        super.handleMatch(info, lookupPath, request);
        RequestCondition condition = info.getActivePatternsCondition();
        if (condition instanceof PathPatternsRequestCondition) {
            PathPatternsRequestCondition pprc = (PathPatternsRequestCondition)condition;
            this.extractMatchDetails(pprc, lookupPath, request);
        } else {
            this.extractMatchDetails((PatternsRequestCondition)condition, lookupPath, request);
        }
        ProducesRequestCondition producesCondition = info.getProducesCondition();
        if (!producesCondition.isEmpty() && !(mediaTypes = producesCondition.getProducibleMediaTypes()).isEmpty()) {
            request.setAttribute(PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE, mediaTypes);
        }
    }

    private void extractMatchDetails(PathPatternsRequestCondition condition, String lookupPath, HttpServletRequest request) {
        Map<Object, Object> uriVariables;
        PathPattern bestPattern;
        if (condition.isEmptyPathMapping()) {
            bestPattern = condition.getFirstPattern();
            uriVariables = Collections.emptyMap();
        } else {
            PathContainer path2 = ServletRequestPathUtils.getParsedRequestPath(request).pathWithinApplication();
            bestPattern = condition.getFirstPattern();
            PathPattern.PathMatchInfo result2 = bestPattern.matchAndExtract(path2);
            Assert.notNull((Object)result2, () -> "Expected bestPattern: " + bestPattern + " to match lookupPath " + path2);
            uriVariables = result2.getUriVariables();
            request.setAttribute(MATRIX_VARIABLES_ATTRIBUTE, result2.getMatrixVariables());
        }
        request.setAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE, bestPattern.getPatternString());
        ServerHttpObservationFilter.findObservationContext(request).ifPresent(context -> context.setPathPattern(bestPattern.getPatternString()));
        request.setAttribute(URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriVariables);
    }

    private void extractMatchDetails(PatternsRequestCondition condition, String lookupPath, HttpServletRequest request) {
        Map<String, String> uriVariables;
        String bestPattern;
        if (condition.isEmptyPathMapping()) {
            bestPattern = lookupPath;
            uriVariables = Collections.emptyMap();
        } else {
            bestPattern = condition.getPatterns().iterator().next();
            uriVariables = this.getPathMatcher().extractUriTemplateVariables(bestPattern, lookupPath);
            if (!this.getUrlPathHelper().shouldRemoveSemicolonContent()) {
                request.setAttribute(MATRIX_VARIABLES_ATTRIBUTE, this.extractMatrixVariables(request, uriVariables));
            }
            uriVariables = this.getUrlPathHelper().decodePathVariables(request, uriVariables);
        }
        request.setAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE, bestPattern);
        ServerHttpObservationFilter.findObservationContext(request).ifPresent(context -> context.setPathPattern(bestPattern));
        request.setAttribute(URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriVariables);
    }

    private Map<String, MultiValueMap<String, String>> extractMatrixVariables(HttpServletRequest request, Map<String, String> uriVariables) {
        LinkedHashMap<String, MultiValueMap<String, String>> result2 = new LinkedHashMap<String, MultiValueMap<String, String>>();
        uriVariables.forEach((uriVarKey, uriVarValue) -> {
            int equalsIndex = uriVarValue.indexOf(61);
            if (equalsIndex == -1) {
                return;
            }
            int semicolonIndex = uriVarValue.indexOf(59);
            if (semicolonIndex != -1 && semicolonIndex != 0) {
                uriVariables.put((String)uriVarKey, uriVarValue.substring(0, semicolonIndex));
            }
            String matrixVariables = semicolonIndex == -1 || semicolonIndex == 0 || equalsIndex < semicolonIndex ? uriVarValue : uriVarValue.substring(semicolonIndex + 1);
            MultiValueMap<String, String> vars = WebUtils.parseMatrixVariables(matrixVariables);
            result2.put((String)uriVarKey, this.getUrlPathHelper().decodeMatrixVariables(request, vars));
        });
        return result2;
    }

    @Override
    @Nullable
    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> infos, String lookupPath, HttpServletRequest request) throws ServletException {
        if (CollectionUtils.isEmpty(infos)) {
            return null;
        }
        PartialMatchHelper helper = new PartialMatchHelper(infos, request);
        if (helper.isEmpty()) {
            return null;
        }
        if (helper.hasMethodsMismatch()) {
            Set<String> methods2 = helper.getAllowedMethods();
            if (HttpMethod.OPTIONS.matches(request.getMethod())) {
                Set<MediaType> mediaTypes = helper.getConsumablePatchMediaTypes();
                HttpOptionsHandler handler = new HttpOptionsHandler(methods2, mediaTypes);
                return new HandlerMethod(handler, HTTP_OPTIONS_HANDLE_METHOD);
            }
            throw new HttpRequestMethodNotSupportedException(request.getMethod(), methods2);
        }
        if (helper.hasConsumesMismatch()) {
            Set<MediaType> mediaTypes = helper.getConsumableMediaTypes();
            MediaType contentType = null;
            if (StringUtils.hasLength(request.getContentType())) {
                try {
                    contentType = MediaType.parseMediaType(request.getContentType());
                }
                catch (InvalidMediaTypeException ex) {
                    throw new HttpMediaTypeNotSupportedException(ex.getMessage(), new ArrayList<MediaType>(mediaTypes));
                }
            }
            throw new HttpMediaTypeNotSupportedException(contentType, new ArrayList<MediaType>(mediaTypes), HttpMethod.valueOf(request.getMethod()));
        }
        if (helper.hasProducesMismatch()) {
            Set<MediaType> mediaTypes = helper.getProducibleMediaTypes();
            throw new HttpMediaTypeNotAcceptableException(new ArrayList<MediaType>(mediaTypes));
        }
        if (helper.hasParamsMismatch()) {
            List<String[]> conditions = helper.getParamConditions();
            throw new UnsatisfiedServletRequestParameterException(conditions, request.getParameterMap());
        }
        return null;
    }

    static {
        try {
            HTTP_OPTIONS_HANDLE_METHOD = HttpOptionsHandler.class.getMethod("handle", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Failed to retrieve internal handler method for HTTP OPTIONS", ex);
        }
    }

    private static final class PartialMatchHelper {
        private final List<PartialMatch> partialMatches = new ArrayList<PartialMatch>();

        PartialMatchHelper(Set<RequestMappingInfo> infos, HttpServletRequest request) {
            for (RequestMappingInfo info : infos) {
                if (info.getActivePatternsCondition().getMatchingCondition(request) == null) continue;
                this.partialMatches.add(new PartialMatch(info, request));
            }
        }

        public boolean isEmpty() {
            return this.partialMatches.isEmpty();
        }

        public boolean hasMethodsMismatch() {
            for (PartialMatch match2 : this.partialMatches) {
                if (!match2.hasMethodsMatch()) continue;
                return false;
            }
            return true;
        }

        public boolean hasConsumesMismatch() {
            for (PartialMatch match2 : this.partialMatches) {
                if (!match2.hasConsumesMatch()) continue;
                return false;
            }
            return true;
        }

        public boolean hasProducesMismatch() {
            for (PartialMatch match2 : this.partialMatches) {
                if (!match2.hasProducesMatch()) continue;
                return false;
            }
            return true;
        }

        public boolean hasParamsMismatch() {
            for (PartialMatch match2 : this.partialMatches) {
                if (!match2.hasParamsMatch()) continue;
                return false;
            }
            return true;
        }

        public Set<String> getAllowedMethods() {
            LinkedHashSet<String> result2 = new LinkedHashSet<String>();
            for (PartialMatch match2 : this.partialMatches) {
                for (RequestMethod method2 : match2.getInfo().getMethodsCondition().getMethods()) {
                    result2.add(method2.name());
                }
            }
            return result2;
        }

        public Set<MediaType> getConsumableMediaTypes() {
            LinkedHashSet<MediaType> result2 = new LinkedHashSet<MediaType>();
            for (PartialMatch match2 : this.partialMatches) {
                if (!match2.hasMethodsMatch()) continue;
                result2.addAll(match2.getInfo().getConsumesCondition().getConsumableMediaTypes());
            }
            return result2;
        }

        public Set<MediaType> getProducibleMediaTypes() {
            LinkedHashSet<MediaType> result2 = new LinkedHashSet<MediaType>();
            for (PartialMatch match2 : this.partialMatches) {
                if (!match2.hasConsumesMatch()) continue;
                result2.addAll(match2.getInfo().getProducesCondition().getProducibleMediaTypes());
            }
            return result2;
        }

        public List<String[]> getParamConditions() {
            ArrayList<String[]> result2 = new ArrayList<String[]>();
            for (PartialMatch match2 : this.partialMatches) {
                Set<NameValueExpression<String>> set2;
                if (!match2.hasProducesMatch() || CollectionUtils.isEmpty(set2 = match2.getInfo().getParamsCondition().getExpressions())) continue;
                int i2 = 0;
                String[] array2 = new String[set2.size()];
                for (NameValueExpression<String> expression : set2) {
                    array2[i2++] = expression.toString();
                }
                result2.add(array2);
            }
            return result2;
        }

        public Set<MediaType> getConsumablePatchMediaTypes() {
            LinkedHashSet<MediaType> result2 = new LinkedHashSet<MediaType>();
            for (PartialMatch match2 : this.partialMatches) {
                Set<RequestMethod> methods2 = match2.getInfo().getMethodsCondition().getMethods();
                if (!methods2.isEmpty() && !methods2.contains((Object)RequestMethod.PATCH)) continue;
                result2.addAll(match2.getInfo().getConsumesCondition().getConsumableMediaTypes());
            }
            return result2;
        }

        private static class PartialMatch {
            private final RequestMappingInfo info;
            private final boolean methodsMatch;
            private final boolean consumesMatch;
            private final boolean producesMatch;
            private final boolean paramsMatch;

            public PartialMatch(RequestMappingInfo info, HttpServletRequest request) {
                this.info = info;
                this.methodsMatch = info.getMethodsCondition().getMatchingCondition(request) != null;
                this.consumesMatch = info.getConsumesCondition().getMatchingCondition(request) != null;
                this.producesMatch = info.getProducesCondition().getMatchingCondition(request) != null;
                this.paramsMatch = info.getParamsCondition().getMatchingCondition(request) != null;
            }

            public RequestMappingInfo getInfo() {
                return this.info;
            }

            public boolean hasMethodsMatch() {
                return this.methodsMatch;
            }

            public boolean hasConsumesMatch() {
                return this.hasMethodsMatch() && this.consumesMatch;
            }

            public boolean hasProducesMatch() {
                return this.hasConsumesMatch() && this.producesMatch;
            }

            public boolean hasParamsMatch() {
                return this.hasProducesMatch() && this.paramsMatch;
            }

            public String toString() {
                return this.info.toString();
            }
        }
    }

    private static class HttpOptionsHandler {
        private final HttpHeaders headers = new HttpHeaders();

        public HttpOptionsHandler(Set<String> declaredMethods, Set<MediaType> acceptPatch) {
            this.headers.setAllow(HttpOptionsHandler.initAllowedHttpMethods(declaredMethods));
            this.headers.setAcceptPatch(new ArrayList<MediaType>(acceptPatch));
        }

        private static Set<HttpMethod> initAllowedHttpMethods(Set<String> declaredMethods) {
            LinkedHashSet<HttpMethod> result2 = new LinkedHashSet<HttpMethod>(declaredMethods.size());
            if (declaredMethods.isEmpty()) {
                for (HttpMethod method2 : HttpMethod.values()) {
                    if (method2 == HttpMethod.TRACE) continue;
                    result2.add(method2);
                }
            } else {
                for (String method3 : declaredMethods) {
                    HttpMethod httpMethod = HttpMethod.valueOf(method3);
                    result2.add(httpMethod);
                    if (httpMethod != HttpMethod.GET) continue;
                    result2.add(HttpMethod.HEAD);
                }
                result2.add(HttpMethod.OPTIONS);
            }
            return result2;
        }

        public HttpHeaders handle() {
            return this.headers;
        }
    }
}

