/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.HttpMediaTypeException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.servlet.mvc.condition.AbstractMediaTypeExpression;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.MediaTypeExpression;

public final class ProducesRequestCondition
extends AbstractRequestCondition<ProducesRequestCondition> {
    private static final ContentNegotiationManager DEFAULT_CONTENT_NEGOTIATION_MANAGER = new ContentNegotiationManager();
    private static final ProducesRequestCondition EMPTY_CONDITION = new ProducesRequestCondition(new String[0]);
    private static final List<ProduceMediaTypeExpression> MEDIA_TYPE_ALL_LIST = Collections.singletonList(new ProduceMediaTypeExpression("*/*"));
    private static final String MEDIA_TYPES_ATTRIBUTE = ProducesRequestCondition.class.getName() + ".MEDIA_TYPES";
    private final List<ProduceMediaTypeExpression> expressions;
    private final ContentNegotiationManager contentNegotiationManager;

    public ProducesRequestCondition(String ... produces) {
        this(produces, (String[])null, (ContentNegotiationManager)null);
    }

    public ProducesRequestCondition(@Nullable String[] produces, @Nullable String[] headers) {
        this(produces, headers, (ContentNegotiationManager)null);
    }

    public ProducesRequestCondition(@Nullable String[] produces, @Nullable String[] headers, @Nullable ContentNegotiationManager manager) {
        this.expressions = this.parseExpressions(produces, headers);
        if (this.expressions.size() > 1) {
            Collections.sort(this.expressions);
        }
        this.contentNegotiationManager = manager != null ? manager : DEFAULT_CONTENT_NEGOTIATION_MANAGER;
    }

    private List<ProduceMediaTypeExpression> parseExpressions(@Nullable String[] produces, @Nullable String[] headers) {
        LinkedHashSet<ProduceMediaTypeExpression> result2 = null;
        if (!ObjectUtils.isEmpty(headers)) {
            for (String header : headers) {
                HeadersRequestCondition.HeaderExpression expr = new HeadersRequestCondition.HeaderExpression(header);
                if (!"Accept".equalsIgnoreCase(expr.name) || expr.value == null) continue;
                for (MediaType mediaType : MediaType.parseMediaTypes((String)expr.value)) {
                    result2 = result2 != null ? result2 : new LinkedHashSet<ProduceMediaTypeExpression>();
                    result2.add(new ProduceMediaTypeExpression(mediaType, expr.isNegated));
                }
            }
        }
        if (!ObjectUtils.isEmpty(produces)) {
            for (String produce2 : produces) {
                result2 = result2 != null ? result2 : new LinkedHashSet<ProduceMediaTypeExpression>();
                result2.add(new ProduceMediaTypeExpression(produce2));
            }
        }
        return result2 != null ? new ArrayList(result2) : Collections.emptyList();
    }

    private ProducesRequestCondition(List<ProduceMediaTypeExpression> expressions, ProducesRequestCondition other) {
        this.expressions = expressions;
        this.contentNegotiationManager = other.contentNegotiationManager;
    }

    public Set<MediaTypeExpression> getExpressions() {
        return new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public Set<MediaType> getProducibleMediaTypes() {
        LinkedHashSet<MediaType> result2 = new LinkedHashSet<MediaType>();
        for (ProduceMediaTypeExpression expression : this.expressions) {
            if (expression.isNegated()) continue;
            result2.add(expression.getMediaType());
        }
        return result2;
    }

    @Override
    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    @Override
    protected List<ProduceMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public ProducesRequestCondition combine(ProducesRequestCondition other) {
        return !other.expressions.isEmpty() ? other : this;
    }

    @Override
    @Nullable
    public ProducesRequestCondition getMatchingCondition(HttpServletRequest request) {
        List<MediaType> acceptedMediaTypes;
        if (CorsUtils.isPreFlightRequest(request)) {
            return EMPTY_CONDITION;
        }
        if (this.isEmpty()) {
            return this;
        }
        try {
            acceptedMediaTypes = this.getAcceptedMediaTypes(request);
        }
        catch (HttpMediaTypeException ex) {
            return null;
        }
        List<ProduceMediaTypeExpression> result2 = this.getMatchingExpressions(acceptedMediaTypes);
        if (!CollectionUtils.isEmpty(result2)) {
            return new ProducesRequestCondition(result2, this);
        }
        if (MediaType.ALL.isPresentIn(acceptedMediaTypes)) {
            return EMPTY_CONDITION;
        }
        return null;
    }

    @Nullable
    private List<ProduceMediaTypeExpression> getMatchingExpressions(List<MediaType> acceptedMediaTypes) {
        ArrayList<ProduceMediaTypeExpression> result2 = null;
        for (ProduceMediaTypeExpression expression : this.expressions) {
            if (!expression.match(acceptedMediaTypes)) continue;
            result2 = result2 != null ? result2 : new ArrayList<ProduceMediaTypeExpression>();
            result2.add(expression);
        }
        return result2;
    }

    @Override
    public int compareTo(ProducesRequestCondition other, HttpServletRequest request) {
        if (this.expressions.isEmpty() && other.expressions.isEmpty()) {
            return 0;
        }
        try {
            List<MediaType> acceptedMediaTypes = this.getAcceptedMediaTypes(request);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                int otherIndex;
                int thisIndex = this.indexOfEqualMediaType(acceptedMediaType);
                int result2 = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfEqualMediaType(acceptedMediaType));
                if (result2 != 0) {
                    return result2;
                }
                thisIndex = this.indexOfIncludedMediaType(acceptedMediaType);
                result2 = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfIncludedMediaType(acceptedMediaType));
                if (result2 == 0) continue;
                return result2;
            }
            return 0;
        }
        catch (HttpMediaTypeNotAcceptableException ex) {
            throw new IllegalStateException("Cannot compare without having any requested media types", ex);
        }
    }

    private List<MediaType> getAcceptedMediaTypes(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
        List<MediaType> result2 = (List<MediaType>)request.getAttribute(MEDIA_TYPES_ATTRIBUTE);
        if (result2 == null) {
            result2 = this.contentNegotiationManager.resolveMediaTypes(new ServletWebRequest(request));
            request.setAttribute(MEDIA_TYPES_ATTRIBUTE, result2);
        }
        return result2;
    }

    private int indexOfEqualMediaType(MediaType mediaType) {
        for (int i2 = 0; i2 < this.getExpressionsToCompare().size(); ++i2) {
            MediaType currentMediaType = this.getExpressionsToCompare().get(i2).getMediaType();
            if (!mediaType.getType().equalsIgnoreCase(currentMediaType.getType()) || !mediaType.getSubtype().equalsIgnoreCase(currentMediaType.getSubtype())) continue;
            return i2;
        }
        return -1;
    }

    private int indexOfIncludedMediaType(MediaType mediaType) {
        for (int i2 = 0; i2 < this.getExpressionsToCompare().size(); ++i2) {
            if (!mediaType.includes(this.getExpressionsToCompare().get(i2).getMediaType())) continue;
            return i2;
        }
        return -1;
    }

    private int compareMatchingMediaTypes(ProducesRequestCondition condition1, int index1, ProducesRequestCondition condition2, int index2) {
        int result2 = 0;
        if (index1 != index2) {
            result2 = index2 - index1;
        } else if (index1 != -1) {
            ProduceMediaTypeExpression expr2;
            ProduceMediaTypeExpression expr1 = condition1.getExpressionsToCompare().get(index1);
            result2 = expr1.compareTo(expr2 = condition2.getExpressionsToCompare().get(index2));
            result2 = result2 != 0 ? result2 : expr1.getMediaType().compareTo(expr2.getMediaType());
        }
        return result2;
    }

    private List<ProduceMediaTypeExpression> getExpressionsToCompare() {
        return this.expressions.isEmpty() ? MEDIA_TYPE_ALL_LIST : this.expressions;
    }

    public static void clearMediaTypesAttribute(HttpServletRequest request) {
        request.removeAttribute(MEDIA_TYPES_ATTRIBUTE);
    }

    static class ProduceMediaTypeExpression
    extends AbstractMediaTypeExpression {
        ProduceMediaTypeExpression(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        ProduceMediaTypeExpression(String expression) {
            super(expression);
        }

        public final boolean match(List<MediaType> acceptedMediaTypes) {
            boolean match2 = this.matchMediaType(acceptedMediaTypes);
            return !this.isNegated() == match2;
        }

        private boolean matchMediaType(List<MediaType> acceptedMediaTypes) {
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                if (!this.getMediaType().isCompatibleWith(acceptedMediaType) || !this.matchParameters(acceptedMediaType)) continue;
                return true;
            }
            return false;
        }
    }
}

