/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.condition.MediaTypeExpression;

abstract class AbstractMediaTypeExpression
implements MediaTypeExpression,
Comparable<AbstractMediaTypeExpression> {
    private final MediaType mediaType;
    private final boolean isNegated;

    AbstractMediaTypeExpression(String expression) {
        if (expression.startsWith("!")) {
            this.isNegated = true;
            expression = expression.substring(1);
        } else {
            this.isNegated = false;
        }
        this.mediaType = MediaType.parseMediaType(expression);
    }

    AbstractMediaTypeExpression(MediaType mediaType, boolean negated) {
        this.mediaType = mediaType;
        this.isNegated = negated;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public boolean isNegated() {
        return this.isNegated;
    }

    @Override
    public int compareTo(AbstractMediaTypeExpression other) {
        MediaType mediaType2;
        MediaType mediaType1 = this.getMediaType();
        if (mediaType1.isMoreSpecific(mediaType2 = other.getMediaType())) {
            return -1;
        }
        if (mediaType1.isLessSpecific(mediaType2)) {
            return 1;
        }
        return 0;
    }

    protected boolean matchParameters(MediaType contentType) {
        for (Map.Entry<String, String> entry : this.getMediaType().getParameters().entrySet()) {
            String value2;
            if (!StringUtils.hasText(entry.getValue()) || !StringUtils.hasText(value2 = contentType.getParameter(entry.getKey())) || entry.getValue().equalsIgnoreCase(value2)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractMediaTypeExpression otherExpr = (AbstractMediaTypeExpression)other;
        return this.mediaType.equals(otherExpr.mediaType) && this.isNegated == otherExpr.isNegated;
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String toString() {
        if (this.isNegated) {
            return "!" + this.mediaType.toString();
        }
        return this.mediaType.toString();
    }
}

