/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.http.CacheControl;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class WebContentInterceptor
extends WebContentGenerator
implements HandlerInterceptor {
    private static PathMatcher defaultPathMatcher = new AntPathMatcher();
    private final PathPatternParser patternParser;
    private PathMatcher pathMatcher = defaultPathMatcher;
    private final Map<PathPattern, Integer> cacheMappings = new HashMap<PathPattern, Integer>();
    private final Map<PathPattern, CacheControl> cacheControlMappings = new HashMap<PathPattern, CacheControl>();

    public WebContentInterceptor() {
        this(PathPatternParser.defaultInstance);
    }

    public WebContentInterceptor(PathPatternParser parser) {
        super(false);
        this.patternParser = parser;
    }

    @Deprecated
    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
    }

    @Deprecated
    public void setUrlDecode(boolean urlDecode) {
    }

    @Deprecated
    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void setCacheMappings(Properties cacheMappings) {
        this.cacheMappings.clear();
        Enumeration<?> propNames = cacheMappings.propertyNames();
        while (propNames.hasMoreElements()) {
            String path2 = (String)propNames.nextElement();
            int cacheSeconds = Integer.parseInt(cacheMappings.getProperty(path2));
            this.cacheMappings.put(this.patternParser.parse(path2), cacheSeconds);
        }
    }

    public void addCacheMapping(CacheControl cacheControl, String ... paths) {
        for (String path2 : paths) {
            this.cacheControlMappings.put(this.patternParser.parse(path2), cacheControl);
        }
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        PathContainer pathContainer;
        this.checkRequest(request);
        Object path2 = ServletRequestPathUtils.getCachedPath(request);
        if (this.pathMatcher != defaultPathMatcher) {
            path2 = path2.toString();
        }
        if (!ObjectUtils.isEmpty(this.cacheControlMappings)) {
            CacheControl control;
            if (path2 instanceof PathContainer) {
                pathContainer = (PathContainer)path2;
                v0 = this.lookupCacheControl(pathContainer);
            } else {
                v0 = control = this.lookupCacheControl((String)path2);
            }
            if (control != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Applying " + control);
                }
                this.applyCacheControl(response, control);
                return true;
            }
        }
        if (!ObjectUtils.isEmpty(this.cacheMappings)) {
            Integer cacheSeconds;
            if (path2 instanceof PathContainer) {
                pathContainer = (PathContainer)path2;
                v1 = this.lookupCacheSeconds(pathContainer);
            } else {
                v1 = cacheSeconds = this.lookupCacheSeconds((String)path2);
            }
            if (cacheSeconds != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Applying cacheSeconds " + cacheSeconds);
                }
                this.applyCacheSeconds(response, cacheSeconds);
                return true;
            }
        }
        this.prepareResponse(response);
        return true;
    }

    @Nullable
    protected CacheControl lookupCacheControl(PathContainer path2) {
        for (Map.Entry<PathPattern, CacheControl> entry : this.cacheControlMappings.entrySet()) {
            if (!entry.getKey().matches(path2)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    protected CacheControl lookupCacheControl(String lookupPath) {
        for (Map.Entry<PathPattern, CacheControl> entry : this.cacheControlMappings.entrySet()) {
            if (!this.pathMatcher.match(entry.getKey().getPatternString(), lookupPath)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    protected Integer lookupCacheSeconds(PathContainer path2) {
        for (Map.Entry<PathPattern, Integer> entry : this.cacheMappings.entrySet()) {
            if (!entry.getKey().matches(path2)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    protected Integer lookupCacheSeconds(String lookupPath) {
        for (Map.Entry<PathPattern, Integer> entry : this.cacheMappings.entrySet()) {
            if (!this.pathMatcher.match(entry.getKey().getPatternString(), lookupPath)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
    }
}

