/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.servlet.handler.PathPatternMatchableHandlerMapping;
import org.springframework.web.servlet.handler.RequestMatchResult;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPatternParser;

public class HandlerMappingIntrospector
implements CorsConfigurationSource,
ApplicationContextAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(HandlerMappingIntrospector.class.getName());
    private static final String CACHED_RESULT_ATTRIBUTE = HandlerMappingIntrospector.class.getName() + ".CachedResult";
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private List<HandlerMapping> handlerMappings;
    private Map<HandlerMapping, PathPatternMatchableHandlerMapping> pathPatternMappings = Collections.emptyMap();
    private final CacheResultLogHelper cacheLogHelper = new CacheResultLogHelper();

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.handlerMappings == null) {
            Assert.notNull((Object)this.applicationContext, "No ApplicationContext");
            this.handlerMappings = HandlerMappingIntrospector.initHandlerMappings(this.applicationContext);
            this.pathPatternMappings = this.handlerMappings.stream().filter(m -> {
                MatchableHandlerMapping hm;
                return m instanceof MatchableHandlerMapping && (hm = (MatchableHandlerMapping)m).getPatternParser() != null;
            }).map(mapping -> (MatchableHandlerMapping)mapping).collect(Collectors.toMap(mapping -> mapping, PathPatternMatchableHandlerMapping::new));
        }
    }

    private static List<HandlerMapping> initHandlerMappings(ApplicationContext context) {
        Map<String, HandlerMapping> beans2 = BeanFactoryUtils.beansOfTypeIncludingAncestors(context, HandlerMapping.class, true, false);
        if (!beans2.isEmpty()) {
            ArrayList<HandlerMapping> mappings = new ArrayList<HandlerMapping>(beans2.values());
            AnnotationAwareOrderComparator.sort(mappings);
            return Collections.unmodifiableList(mappings);
        }
        return Collections.unmodifiableList(HandlerMappingIntrospector.initFallback(context));
    }

    private static List<HandlerMapping> initFallback(ApplicationContext applicationContext) {
        Properties properties;
        try {
            ClassPathResource resource = new ClassPathResource("DispatcherServlet.properties", DispatcherServlet.class);
            properties = PropertiesLoaderUtils.loadProperties(resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load DispatcherServlet.properties: " + ex.getMessage());
        }
        String value2 = properties.getProperty(HandlerMapping.class.getName());
        String[] names2 = StringUtils.commaDelimitedListToStringArray(value2);
        ArrayList<HandlerMapping> result2 = new ArrayList<HandlerMapping>(names2.length);
        for (String name2 : names2) {
            try {
                Class<?> clazz = ClassUtils.forName(name2, DispatcherServlet.class.getClassLoader());
                Object mapping = applicationContext.getAutowireCapableBeanFactory().createBean(clazz);
                result2.add((HandlerMapping)mapping);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Could not find default HandlerMapping [" + name2 + "]");
            }
        }
        return result2;
    }

    public List<HandlerMapping> getHandlerMappings() {
        return this.handlerMappings != null ? this.handlerMappings : Collections.emptyList();
    }

    public Filter createCacheFilter() {
        return (request, response, chain2) -> {
            CachedResult previous = this.setCache((HttpServletRequest)request);
            try {
                chain2.doFilter(request, response);
            }
            finally {
                this.resetCache(request, previous);
            }
        };
    }

    @Nullable
    public CachedResult setCache(HttpServletRequest request) {
        CachedResult previous = (CachedResult)request.getAttribute(CACHED_RESULT_ATTRIBUTE);
        if (previous == null || !previous.matches(request)) {
            CachedResult result2;
            AttributesPreservingRequest wrapped = new AttributesPreservingRequest(request);
            try {
                result2 = this.doWithHandlerMapping(wrapped, false, (mapping, executionChain) -> {
                    MatchableHandlerMapping matchableMapping = this.createMatchableHandlerMapping((HandlerMapping)mapping, wrapped);
                    CorsConfiguration corsConfig = HandlerMappingIntrospector.getCorsConfiguration(executionChain, wrapped);
                    return new CachedResult(request, matchableMapping, corsConfig, null, null);
                });
            }
            catch (Exception ex) {
                try {
                    AttributesPreservingRequest requestToUse = new AttributesPreservingRequest(request);
                    result2 = this.doWithHandlerMapping(requestToUse, true, (mapping, executionChain) -> {
                        CorsConfiguration corsConfig = HandlerMappingIntrospector.getCorsConfiguration(executionChain, wrapped);
                        return new CachedResult(request, null, corsConfig, ex, null);
                    });
                }
                catch (Exception ex2) {
                    result2 = new CachedResult(request, null, null, ex, new IllegalStateException(ex2));
                }
            }
            if (result2 == null) {
                result2 = new CachedResult(request, null, null, null, null);
            }
            request.setAttribute(CACHED_RESULT_ATTRIBUTE, result2);
        }
        return previous;
    }

    public void resetCache(ServletRequest request, @Nullable CachedResult cachedResult) {
        request.setAttribute(CACHED_RESULT_ATTRIBUTE, cachedResult);
    }

    @Nullable
    public MatchableHandlerMapping getMatchableHandlerMapping(HttpServletRequest request) throws Exception {
        CachedResult result2 = CachedResult.getResultFor(request);
        if (result2 != null) {
            return result2.getHandlerMapping();
        }
        this.cacheLogHelper.logHandlerMappingCacheMiss(request);
        AttributesPreservingRequest requestToUse = new AttributesPreservingRequest(request);
        return this.doWithHandlerMapping(requestToUse, false, (mapping, executionChain) -> this.createMatchableHandlerMapping((HandlerMapping)mapping, requestToUse));
    }

    private MatchableHandlerMapping createMatchableHandlerMapping(HandlerMapping mapping, HttpServletRequest request) {
        if (mapping instanceof MatchableHandlerMapping) {
            PathPatternMatchableHandlerMapping pathPatternMapping = this.pathPatternMappings.get(mapping);
            if (pathPatternMapping != null) {
                RequestPath requestPath = ServletRequestPathUtils.getParsedRequestPath(request);
                return new LookupPathMatchableHandlerMapping(pathPatternMapping, requestPath);
            }
            String lookupPath = (String)request.getAttribute(UrlPathHelper.PATH_ATTRIBUTE);
            return new LookupPathMatchableHandlerMapping((MatchableHandlerMapping)mapping, lookupPath);
        }
        throw new IllegalStateException("HandlerMapping is not a MatchableHandlerMapping");
    }

    @Override
    @Nullable
    public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        CachedResult result2 = CachedResult.getResultFor(request);
        if (result2 != null) {
            return result2.getCorsConfig();
        }
        this.cacheLogHelper.logCorsConfigCacheMiss(request);
        try {
            boolean ignoreException = true;
            AttributesPreservingRequest requestToUse = new AttributesPreservingRequest(request);
            return this.doWithHandlerMapping(requestToUse, ignoreException, (handlerMapping, executionChain) -> HandlerMappingIntrospector.getCorsConfiguration(executionChain, requestToUse));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Nullable
    private static CorsConfiguration getCorsConfiguration(HandlerExecutionChain chain2, HttpServletRequest request) {
        for (HandlerInterceptor interceptor : chain2.getInterceptorList()) {
            if (!(interceptor instanceof CorsConfigurationSource)) continue;
            CorsConfigurationSource source2 = (CorsConfigurationSource)((Object)interceptor);
            return source2.getCorsConfiguration(request);
        }
        Object object = chain2.getHandler();
        if (object instanceof CorsConfigurationSource) {
            CorsConfigurationSource source3 = (CorsConfigurationSource)object;
            return source3.getCorsConfiguration(request);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T doWithHandlerMapping(HttpServletRequest request, boolean ignoreException, BiFunction<HandlerMapping, HandlerExecutionChain, T> extractor) throws Exception {
        Assert.state(this.handlerMappings != null, "HandlerMapping's not initialized");
        boolean parsePath = !this.pathPatternMappings.isEmpty();
        RequestPath previousPath = null;
        if (parsePath) {
            previousPath = (RequestPath)request.getAttribute(ServletRequestPathUtils.PATH_ATTRIBUTE);
            ServletRequestPathUtils.parseAndCache(request);
        }
        try {
            for (HandlerMapping handlerMapping : this.handlerMappings) {
                HandlerExecutionChain chain2;
                block8: {
                    chain2 = null;
                    try {
                        chain2 = handlerMapping.getHandler(request);
                    }
                    catch (Exception ex) {
                        if (ignoreException) break block8;
                        throw ex;
                    }
                }
                if (chain2 == null) continue;
                T t = extractor.apply(handlerMapping, chain2);
                return t;
            }
        }
        finally {
            if (parsePath) {
                ServletRequestPathUtils.setParsedRequestPath(previousPath, request);
            }
        }
        return null;
    }

    private static class CacheResultLogHelper {
        private final Map<String, AtomicInteger> counters = Map.of("MatchableHandlerMapping", new AtomicInteger(), "CorsConfiguration", new AtomicInteger());

        private CacheResultLogHelper() {
        }

        public void logHandlerMappingCacheMiss(HttpServletRequest request) {
            this.logCacheMiss("MatchableHandlerMapping", request);
        }

        public void logCorsConfigCacheMiss(HttpServletRequest request) {
            this.logCacheMiss("CorsConfiguration", request);
        }

        private void logCacheMiss(String label2, HttpServletRequest request) {
            AtomicInteger counter = this.counters.get(label2);
            Assert.notNull((Object)counter, "Expected '" + label2 + "' counter.");
            String message2 = CacheResultLogHelper.getLogMessage(label2, request);
            if (logger.isWarnEnabled() && counter.getAndIncrement() == 0) {
                logger.warn(message2 + " This is logged once only at WARN level, and every time at TRACE.");
            } else if (logger.isTraceEnabled()) {
                logger.trace("No CachedResult, performing " + label2 + " lookup instead.");
            }
        }

        private static String getLogMessage(String label2, HttpServletRequest request) {
            return "Cache miss for " + request.getDispatcherType() + " dispatch to '" + request.getRequestURI() + "' (previous " + request.getAttribute(CACHED_RESULT_ATTRIBUTE) + "). Performing " + label2 + " lookup.";
        }
    }

    public static final class CachedResult {
        private final DispatcherType dispatcherType;
        private final String requestURI;
        @Nullable
        private final MatchableHandlerMapping handlerMapping;
        @Nullable
        private final CorsConfiguration corsConfig;
        @Nullable
        private final Exception failure;
        @Nullable
        private final IllegalStateException corsConfigFailure;

        private CachedResult(HttpServletRequest request, @Nullable MatchableHandlerMapping mapping, @Nullable CorsConfiguration config, @Nullable Exception failure, @Nullable IllegalStateException corsConfigFailure) {
            this.dispatcherType = request.getDispatcherType();
            this.requestURI = request.getRequestURI();
            this.handlerMapping = mapping;
            this.corsConfig = config;
            this.failure = failure;
            this.corsConfigFailure = corsConfigFailure;
        }

        public boolean matches(HttpServletRequest request) {
            return this.dispatcherType.equals((Object)request.getDispatcherType()) && this.requestURI.equals(request.getRequestURI());
        }

        @Nullable
        public MatchableHandlerMapping getHandlerMapping() throws Exception {
            if (this.failure != null) {
                throw this.failure;
            }
            return this.handlerMapping;
        }

        @Nullable
        public CorsConfiguration getCorsConfig() {
            if (this.corsConfigFailure != null) {
                throw this.corsConfigFailure;
            }
            return this.corsConfig;
        }

        public String toString() {
            return "CachedResult for " + this.dispatcherType + " dispatch to '" + this.requestURI + "'";
        }

        @Nullable
        public static CachedResult getResultFor(HttpServletRequest request) {
            CachedResult result2 = (CachedResult)request.getAttribute(CACHED_RESULT_ATTRIBUTE);
            return result2 != null && result2.matches(request) ? result2 : null;
        }
    }

    private static class AttributesPreservingRequest
    extends HttpServletRequestWrapper {
        private final Map<String, Object> attributes;

        AttributesPreservingRequest(HttpServletRequest request) {
            super(request);
            this.attributes = this.initAttributes(request);
            this.attributes.put(AbstractHandlerMapping.SUPPRESS_LOGGING_ATTRIBUTE, Boolean.TRUE);
        }

        private Map<String, Object> initAttributes(HttpServletRequest request) {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            Enumeration<String> names2 = request.getAttributeNames();
            while (names2.hasMoreElements()) {
                String name2 = names2.nextElement();
                map2.put(name2, request.getAttribute(name2));
            }
            return map2;
        }

        @Override
        public void setAttribute(String name2, Object value2) {
            this.attributes.put(name2, value2);
        }

        @Override
        @Nullable
        public Object getAttribute(String name2) {
            return this.attributes.get(name2);
        }

        @Override
        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.attributes.keySet());
        }

        @Override
        public void removeAttribute(String name2) {
            this.attributes.remove(name2);
        }
    }

    private static class LookupPathMatchableHandlerMapping
    implements MatchableHandlerMapping {
        private final MatchableHandlerMapping delegate;
        private final Object lookupPath;
        private final String pathAttributeName;

        LookupPathMatchableHandlerMapping(MatchableHandlerMapping delegate, Object lookupPath) {
            this.delegate = delegate;
            this.lookupPath = lookupPath;
            this.pathAttributeName = lookupPath instanceof RequestPath ? ServletRequestPathUtils.PATH_ATTRIBUTE : UrlPathHelper.PATH_ATTRIBUTE;
        }

        @Override
        @Nullable
        public PathPatternParser getPatternParser() {
            return this.delegate.getPatternParser();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public RequestMatchResult match(HttpServletRequest request, String pattern) {
            pattern = this.initFullPathPattern(pattern);
            Object previousPath = request.getAttribute(this.pathAttributeName);
            request.setAttribute(this.pathAttributeName, this.lookupPath);
            try {
                RequestMatchResult requestMatchResult = this.delegate.match(request, pattern);
                return requestMatchResult;
            }
            finally {
                request.setAttribute(this.pathAttributeName, previousPath);
            }
        }

        private String initFullPathPattern(String pattern) {
            PathPatternParser parser = this.getPatternParser() != null ? this.getPatternParser() : PathPatternParser.defaultInstance;
            return parser.initFullPathPattern(pattern);
        }

        @Override
        @Nullable
        public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
            return this.delegate.getHandler(request);
        }
    }
}

