/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.servlet.function.ChangePathPatternParserVisitor;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public abstract class RequestPredicates {
    private static final Log logger = LogFactory.getLog(RequestPredicates.class);

    public static RequestPredicate all() {
        return request -> true;
    }

    public static RequestPredicate method(HttpMethod httpMethod) {
        Assert.notNull((Object)httpMethod, "HttpMethod must not be null");
        return new SingleHttpMethodPredicate(httpMethod);
    }

    public static RequestPredicate methods(HttpMethod ... httpMethods) {
        Assert.notEmpty((Object[])httpMethods, "HttpMethods must not be empty");
        if (httpMethods.length == 1) {
            return new SingleHttpMethodPredicate(httpMethods[0]);
        }
        return new MultipleHttpMethodsPredicate(httpMethods);
    }

    public static RequestPredicate path(String pattern) {
        Assert.notNull((Object)pattern, "'pattern' must not be null");
        PathPatternParser parser = PathPatternParser.defaultInstance;
        pattern = parser.initFullPathPattern(pattern);
        return RequestPredicates.pathPredicates(parser).apply(pattern);
    }

    public static Function<String, RequestPredicate> pathPredicates(PathPatternParser patternParser) {
        Assert.notNull((Object)patternParser, "PathPatternParser must not be null");
        return pattern -> new PathPatternPredicate(patternParser.parse((String)pattern));
    }

    public static RequestPredicate headers(Predicate<ServerRequest.Headers> headersPredicate) {
        return new HeadersPredicate(headersPredicate);
    }

    public static RequestPredicate contentType(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, "'mediaTypes' must not be empty");
        if (mediaTypes.length == 1) {
            return new SingleContentTypePredicate(mediaTypes[0]);
        }
        return new MultipleContentTypesPredicate(mediaTypes);
    }

    public static RequestPredicate accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, "'mediaTypes' must not be empty");
        if (mediaTypes.length == 1) {
            return new SingleAcceptPredicate(mediaTypes[0]);
        }
        return new MultipleAcceptsPredicate(mediaTypes);
    }

    public static RequestPredicate GET(String pattern) {
        return RequestPredicates.method(HttpMethod.GET).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate HEAD(String pattern) {
        return RequestPredicates.method(HttpMethod.HEAD).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate POST(String pattern) {
        return RequestPredicates.method(HttpMethod.POST).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PUT(String pattern) {
        return RequestPredicates.method(HttpMethod.PUT).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PATCH(String pattern) {
        return RequestPredicates.method(HttpMethod.PATCH).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate DELETE(String pattern) {
        return RequestPredicates.method(HttpMethod.DELETE).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate OPTIONS(String pattern) {
        return RequestPredicates.method(HttpMethod.OPTIONS).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate pathExtension(String extension) {
        Assert.notNull((Object)extension, "'extension' must not be null");
        return new PathExtensionPredicate(extension);
    }

    public static RequestPredicate pathExtension(Predicate<String> extensionPredicate) {
        return new PathExtensionPredicate(extensionPredicate);
    }

    public static RequestPredicate param(String name2, String value2) {
        return new ParamPredicate(name2, value2);
    }

    public static RequestPredicate param(String name2, Predicate<String> predicate) {
        return new ParamPredicate(name2, predicate);
    }

    private static void traceMatch(String prefix, Object desired, @Nullable Object actual, boolean match2) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match2 ? "matches" : "does not match", actual));
        }
    }

    private static PathPattern mergePatterns(@Nullable PathPattern oldPattern, PathPattern newPattern) {
        if (oldPattern != null) {
            return oldPattern.combine(newPattern);
        }
        return newPattern;
    }

    private static <K, V> Map<K, V> mergeMaps(Map<K, V> left2, Map<K, V> right) {
        if (left2.isEmpty()) {
            if (right.isEmpty()) {
                return Collections.emptyMap();
            }
            return right;
        }
        if (right.isEmpty()) {
            return left2;
        }
        LinkedHashMap<K, V> result2 = CollectionUtils.newLinkedHashMap(left2.size() + right.size());
        result2.putAll(left2);
        result2.putAll(right);
        return result2;
    }

    private static class SingleHttpMethodPredicate
    implements RequestPredicate {
        private final HttpMethod httpMethod;

        public SingleHttpMethodPredicate(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public boolean test(ServerRequest request) {
            HttpMethod method2 = SingleHttpMethodPredicate.method(request);
            boolean match2 = this.httpMethod.equals(method2);
            RequestPredicates.traceMatch("Method", this.httpMethod, method2, match2);
            return match2;
        }

        static HttpMethod method(ServerRequest request) {
            String accessControlRequestMethod;
            if (CorsUtils.isPreFlightRequest(request.servletRequest()) && (accessControlRequestMethod = request.headers().firstHeader("Access-Control-Request-Method")) != null) {
                return HttpMethod.valueOf(accessControlRequestMethod);
            }
            return request.method();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.method(Set.of(this.httpMethod));
        }

        public String toString() {
            return this.httpMethod.toString();
        }
    }

    private static class MultipleHttpMethodsPredicate
    implements RequestPredicate {
        private final Set<HttpMethod> httpMethods;

        public MultipleHttpMethodsPredicate(HttpMethod[] httpMethods) {
            this.httpMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(httpMethods));
        }

        @Override
        public boolean test(ServerRequest request) {
            HttpMethod method2 = SingleHttpMethodPredicate.method(request);
            boolean match2 = this.httpMethods.contains(method2);
            RequestPredicates.traceMatch("Method", this.httpMethods, method2, match2);
            return match2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.method(Collections.unmodifiableSet(this.httpMethods));
        }

        public String toString() {
            return this.httpMethods.toString();
        }
    }

    private static class HeadersPredicate
    implements RequestPredicate {
        private final Predicate<ServerRequest.Headers> headersPredicate;

        public HeadersPredicate(Predicate<ServerRequest.Headers> headersPredicate) {
            Assert.notNull(headersPredicate, "Predicate must not be null");
            this.headersPredicate = headersPredicate;
        }

        @Override
        public boolean test(ServerRequest request) {
            if (CorsUtils.isPreFlightRequest(request.servletRequest())) {
                return true;
            }
            return this.headersPredicate.test(request.headers());
        }

        public String toString() {
            return this.headersPredicate.toString();
        }
    }

    private static class SingleContentTypePredicate
    extends HeadersPredicate {
        private final MediaType mediaType;

        public SingleContentTypePredicate(MediaType mediaType) {
            super((ServerRequest.Headers headers) -> {
                MediaType contentType = headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
                boolean match2 = mediaType.includes(contentType);
                RequestPredicates.traceMatch("Content-Type", mediaType, contentType, match2);
                return match2;
            });
            this.mediaType = mediaType;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Content-Type", this.mediaType.toString());
        }

        @Override
        public String toString() {
            return "Content-Type: " + this.mediaType;
        }
    }

    private static class MultipleContentTypesPredicate
    extends HeadersPredicate {
        private final MediaType[] mediaTypes;

        public MultipleContentTypesPredicate(MediaType[] mediaTypes) {
            super(headers -> {
                MediaType contentType = headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
                boolean match2 = false;
                for (MediaType mediaType : mediaTypes) {
                    if (!mediaType.includes(contentType)) continue;
                    match2 = true;
                    break;
                }
                RequestPredicates.traceMatch("Content-Type", mediaTypes, contentType, match2);
                return match2;
            });
            this.mediaTypes = mediaTypes;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Content-Type", Arrays.toString(this.mediaTypes));
        }

        @Override
        public String toString() {
            return "Content-Type: " + Arrays.toString(this.mediaTypes);
        }
    }

    private static class SingleAcceptPredicate
    extends HeadersPredicate {
        private final MediaType mediaType;

        public SingleAcceptPredicate(MediaType mediaType) {
            super((ServerRequest.Headers headers) -> {
                List<MediaType> acceptedMediaTypes = SingleAcceptPredicate.acceptedMediaTypes(headers);
                boolean match2 = false;
                for (MediaType acceptedMediaType : acceptedMediaTypes) {
                    if (!acceptedMediaType.isCompatibleWith(mediaType)) continue;
                    match2 = true;
                    break;
                }
                RequestPredicates.traceMatch("Accept", mediaType, acceptedMediaTypes, match2);
                return match2;
            });
            this.mediaType = mediaType;
        }

        static List<MediaType> acceptedMediaTypes(ServerRequest.Headers headers) {
            List<MediaType> acceptedMediaTypes = headers.accept();
            if (acceptedMediaTypes.isEmpty()) {
                acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
            } else {
                MimeTypeUtils.sortBySpecificity(acceptedMediaTypes);
            }
            return acceptedMediaTypes;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Accept", this.mediaType.toString());
        }

        @Override
        public String toString() {
            return "Accept: " + this.mediaType;
        }
    }

    private static class MultipleAcceptsPredicate
    extends HeadersPredicate {
        private final MediaType[] mediaTypes;

        public MultipleAcceptsPredicate(MediaType[] mediaTypes) {
            super(headers -> {
                List<MediaType> acceptedMediaTypes = SingleAcceptPredicate.acceptedMediaTypes(headers);
                boolean match2 = false;
                block0: for (MediaType acceptedMediaType : acceptedMediaTypes) {
                    for (MediaType mediaType : mediaTypes) {
                        if (!acceptedMediaType.isCompatibleWith(mediaType)) continue;
                        match2 = true;
                        break block0;
                    }
                }
                RequestPredicates.traceMatch("Accept", mediaTypes, acceptedMediaTypes, match2);
                return match2;
            });
            this.mediaTypes = mediaTypes;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Accept", Arrays.toString(this.mediaTypes));
        }

        @Override
        public String toString() {
            return "Accept: " + Arrays.toString(this.mediaTypes);
        }
    }

    private static class PathExtensionPredicate
    implements RequestPredicate {
        private final Predicate<String> extensionPredicate;
        @Nullable
        private final String extension;

        public PathExtensionPredicate(Predicate<String> extensionPredicate) {
            Assert.notNull(extensionPredicate, "Predicate must not be null");
            this.extensionPredicate = extensionPredicate;
            this.extension = null;
        }

        public PathExtensionPredicate(String extension) {
            Assert.notNull((Object)extension, "Extension must not be null");
            this.extensionPredicate = s2 -> {
                boolean match2 = extension.equalsIgnoreCase((String)s2);
                RequestPredicates.traceMatch("Extension", extension, s2, match2);
                return match2;
            };
            this.extension = extension;
        }

        @Override
        public boolean test(ServerRequest request) {
            String pathExtension = UriUtils.extractFileExtension(request.path());
            return this.extensionPredicate.test(pathExtension);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.pathExtension(this.extension != null ? this.extension : this.extensionPredicate.toString());
        }

        public String toString() {
            return String.format("*.%s", this.extension != null ? this.extension : this.extensionPredicate);
        }
    }

    private static class ParamPredicate
    implements RequestPredicate {
        private final String name;
        private final Predicate<String> valuePredicate;
        @Nullable
        private final String value;

        public ParamPredicate(String name2, Predicate<String> valuePredicate) {
            Assert.notNull((Object)name2, "Name must not be null");
            Assert.notNull(valuePredicate, "Predicate must not be null");
            this.name = name2;
            this.valuePredicate = valuePredicate;
            this.value = null;
        }

        public ParamPredicate(String name2, String value2) {
            Assert.notNull((Object)name2, "Name must not be null");
            Assert.notNull((Object)value2, "Value must not be null");
            this.name = name2;
            this.valuePredicate = value2::equals;
            this.value = value2;
        }

        @Override
        public boolean test(ServerRequest request) {
            Optional<String> s2 = request.param(this.name);
            return s2.filter(this.valuePredicate).isPresent();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.param(this.name, this.value != null ? this.value : this.valuePredicate.toString());
        }

        public String toString() {
            return String.format("?%s %s", this.name, this.value != null ? this.value : this.valuePredicate);
        }
    }

    private static class PathPatternPredicate
    extends RequestModifyingPredicate
    implements ChangePathPatternParserVisitor.Target {
        private PathPattern pattern;

        public PathPatternPredicate(PathPattern pattern) {
            Assert.notNull((Object)pattern, "'pattern' must not be null");
            this.pattern = pattern;
        }

        @Override
        protected RequestModifyingPredicate.Result testInternal(ServerRequest request) {
            PathContainer pathContainer = request.requestPath().pathWithinApplication();
            PathPattern.PathMatchInfo info = this.pattern.matchAndExtract(pathContainer);
            RequestPredicates.traceMatch("Pattern", this.pattern.getPatternString(), request.path(), info != null);
            if (info != null) {
                return RequestModifyingPredicate.Result.of(true, attributes -> this.modifyAttributes((Map<String, Object>)attributes, request, info.getUriVariables()));
            }
            return RequestModifyingPredicate.Result.of(false);
        }

        private void modifyAttributes(Map<String, Object> attributes, ServerRequest request, Map<String, String> variables) {
            Map<String, String> pathVariables = RequestPredicates.mergeMaps(request.pathVariables(), variables);
            attributes.put(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.unmodifiableMap(pathVariables));
            PathPattern pattern = RequestPredicates.mergePatterns((PathPattern)attributes.get(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE), this.pattern);
            attributes.put(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE, pattern);
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            return Optional.ofNullable(this.pattern.matchStartOfPath(request.requestPath().pathWithinApplication())).map(info -> new NestedPathPatternServerRequestWrapper(request, (PathPattern.PathRemainingMatchInfo)info, this.pattern));
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.path(this.pattern.getPatternString());
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            String patternString = this.pattern.getPatternString();
            this.pattern = parser.parse(patternString);
        }

        public String toString() {
            return this.pattern.getPatternString();
        }
    }

    private static class NestedPathPatternServerRequestWrapper
    extends ExtendedAttributesServerRequestWrapper {
        private final RequestPath requestPath;

        public NestedPathPatternServerRequestWrapper(ServerRequest request, PathPattern.PathRemainingMatchInfo info, PathPattern pattern) {
            super(request, NestedPathPatternServerRequestWrapper.mergeAttributes(request, info.getUriVariables(), pattern));
            this.requestPath = NestedPathPatternServerRequestWrapper.requestPath(request.requestPath(), info);
        }

        private static Map<String, Object> mergeAttributes(ServerRequest request, Map<String, String> newPathVariables, PathPattern newPathPattern) {
            Map<String, String> oldPathVariables = request.pathVariables();
            PathPattern oldPathPattern = request.attribute(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE).orElse(null);
            LinkedHashMap<String, Object> result2 = CollectionUtils.newLinkedHashMap(2);
            result2.put(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, RequestPredicates.mergeMaps(oldPathVariables, newPathVariables));
            result2.put(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE, RequestPredicates.mergePatterns(oldPathPattern, newPathPattern));
            return result2;
        }

        private static RequestPath requestPath(RequestPath original, PathPattern.PathRemainingMatchInfo info) {
            StringBuilder contextPath = new StringBuilder(original.contextPath().value());
            contextPath.append(info.getPathMatched().value());
            int length2 = contextPath.length();
            if (length2 > 0 && contextPath.charAt(length2 - 1) == '/') {
                contextPath.setLength(length2 - 1);
            }
            return original.modifyContextPath(contextPath.toString());
        }

        @Override
        public RequestPath requestPath() {
            return this.requestPath;
        }

        @Override
        public String path() {
            return this.requestPath.pathWithinApplication().value();
        }

        @Override
        @Deprecated
        public PathContainer pathContainer() {
            return this.requestPath;
        }
    }

    private static class ExtendedAttributesServerRequestWrapper
    extends DelegatingServerRequest {
        private final Map<String, Object> attributes;

        public ExtendedAttributesServerRequestWrapper(ServerRequest delegate, Map<String, Object> newAttributes) {
            super(delegate);
            Assert.notNull(newAttributes, "NewAttributes must not be null");
            this.attributes = RequestPredicates.mergeMaps(delegate.attributes(), newAttributes);
        }

        @Override
        public Optional<Object> attribute(String name2) {
            return Optional.ofNullable(this.attributes.get(name2));
        }

        @Override
        public Map<String, Object> attributes() {
            return this.attributes;
        }

        @Override
        public String pathVariable(String name2) {
            Map<String, String> pathVariables = this.pathVariables();
            if (pathVariables.containsKey(name2)) {
                return pathVariables.get(name2);
            }
            throw new IllegalArgumentException("No path variable with name \"" + name2 + "\" available");
        }

        @Override
        public Map<String, String> pathVariables() {
            return this.attributes.getOrDefault(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.emptyMap());
        }
    }

    private static abstract class DelegatingServerRequest
    implements ServerRequest {
        private final ServerRequest delegate;

        protected DelegatingServerRequest(ServerRequest delegate) {
            Assert.notNull((Object)delegate, "Delegate must not be null");
            this.delegate = delegate;
        }

        @Override
        public HttpMethod method() {
            return this.delegate.method();
        }

        @Override
        @Deprecated
        public String methodName() {
            return this.delegate.methodName();
        }

        @Override
        public URI uri() {
            return this.delegate.uri();
        }

        @Override
        public UriBuilder uriBuilder() {
            return this.delegate.uriBuilder();
        }

        @Override
        public String path() {
            return this.delegate.path();
        }

        @Override
        @Deprecated
        public PathContainer pathContainer() {
            return this.delegate.pathContainer();
        }

        @Override
        public RequestPath requestPath() {
            return this.delegate.requestPath();
        }

        @Override
        public ServerRequest.Headers headers() {
            return this.delegate.headers();
        }

        @Override
        public MultiValueMap<String, Cookie> cookies() {
            return this.delegate.cookies();
        }

        @Override
        public Optional<InetSocketAddress> remoteAddress() {
            return this.delegate.remoteAddress();
        }

        @Override
        public List<HttpMessageConverter<?>> messageConverters() {
            return this.delegate.messageConverters();
        }

        @Override
        public <T> T body(Class<T> bodyType) throws ServletException, IOException {
            return this.delegate.body(bodyType);
        }

        @Override
        public <T> T body(ParameterizedTypeReference<T> bodyType) throws ServletException, IOException {
            return this.delegate.body(bodyType);
        }

        @Override
        public <T> T bind(Class<T> bindType) throws BindException {
            return this.delegate.bind(bindType);
        }

        @Override
        public <T> T bind(Class<T> bindType, Consumer<WebDataBinder> dataBinderCustomizer) throws BindException {
            return this.delegate.bind(bindType, dataBinderCustomizer);
        }

        @Override
        public Optional<Object> attribute(String name2) {
            return this.delegate.attribute(name2);
        }

        @Override
        public Map<String, Object> attributes() {
            return this.delegate.attributes();
        }

        @Override
        public Optional<String> param(String name2) {
            return this.delegate.param(name2);
        }

        @Override
        public MultiValueMap<String, String> params() {
            return this.delegate.params();
        }

        @Override
        public MultiValueMap<String, Part> multipartData() throws IOException, ServletException {
            return this.delegate.multipartData();
        }

        @Override
        public String pathVariable(String name2) {
            return this.delegate.pathVariable(name2);
        }

        @Override
        public Map<String, String> pathVariables() {
            return this.delegate.pathVariables();
        }

        @Override
        public HttpSession session() {
            return this.delegate.session();
        }

        @Override
        public Optional<Principal> principal() {
            return this.delegate.principal();
        }

        @Override
        public HttpServletRequest servletRequest() {
            return this.delegate.servletRequest();
        }

        @Override
        public Optional<ServerResponse> checkNotModified(Instant lastModified) {
            return this.delegate.checkNotModified(lastModified);
        }

        @Override
        public Optional<ServerResponse> checkNotModified(String etag) {
            return this.delegate.checkNotModified(etag);
        }

        @Override
        public Optional<ServerResponse> checkNotModified(Instant lastModified, String etag) {
            return this.delegate.checkNotModified(lastModified, etag);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static class OrRequestPredicate
    extends RequestModifyingPredicate
    implements ChangePathPatternParserVisitor.Target {
        private final RequestPredicate left;
        private final RequestModifyingPredicate leftModifying;
        private final RequestPredicate right;
        private final RequestModifyingPredicate rightModifying;

        public OrRequestPredicate(RequestPredicate left2, RequestPredicate right) {
            Assert.notNull((Object)left2, "Left RequestPredicate must not be null");
            Assert.notNull((Object)right, "Right RequestPredicate must not be null");
            this.left = left2;
            this.leftModifying = OrRequestPredicate.of(left2);
            this.right = right;
            this.rightModifying = OrRequestPredicate.of(right);
        }

        @Override
        protected RequestModifyingPredicate.Result testInternal(ServerRequest request) {
            RequestModifyingPredicate.Result leftResult = this.leftModifying.testInternal(request);
            if (leftResult.value()) {
                return leftResult;
            }
            return this.rightModifying.testInternal(request);
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            Optional<ServerRequest> leftResult = this.left.nest(request);
            if (leftResult.isPresent()) {
                return leftResult;
            }
            return this.right.nest(request);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startOr();
            this.left.accept(visitor);
            visitor.or();
            this.right.accept(visitor);
            visitor.endOr();
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            ChangePathPatternParserVisitor.Target target2;
            RequestPredicate requestPredicate = this.left;
            if (requestPredicate instanceof ChangePathPatternParserVisitor.Target) {
                target2 = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target2.changeParser(parser);
            }
            if ((requestPredicate = this.right) instanceof ChangePathPatternParserVisitor.Target) {
                target2 = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target2.changeParser(parser);
            }
        }

        public String toString() {
            return String.format("(%s || %s)", this.left, this.right);
        }
    }

    static class NegateRequestPredicate
    extends RequestModifyingPredicate
    implements ChangePathPatternParserVisitor.Target {
        private final RequestPredicate delegate;
        private final RequestModifyingPredicate delegateModifying;

        public NegateRequestPredicate(RequestPredicate delegate) {
            Assert.notNull((Object)delegate, "Delegate must not be null");
            this.delegate = delegate;
            this.delegateModifying = NegateRequestPredicate.of(delegate);
        }

        @Override
        protected RequestModifyingPredicate.Result testInternal(ServerRequest request) {
            RequestModifyingPredicate.Result result2 = this.delegateModifying.testInternal(request);
            return RequestModifyingPredicate.Result.of(!result2.value(), result2::modifyAttributes);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startNegate();
            this.delegate.accept(visitor);
            visitor.endNegate();
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            RequestPredicate requestPredicate = this.delegate;
            if (requestPredicate instanceof ChangePathPatternParserVisitor.Target) {
                ChangePathPatternParserVisitor.Target target2 = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target2.changeParser(parser);
            }
        }

        public String toString() {
            return "!" + this.delegate.toString();
        }
    }

    static class AndRequestPredicate
    extends RequestModifyingPredicate
    implements ChangePathPatternParserVisitor.Target {
        private final RequestPredicate left;
        private final RequestModifyingPredicate leftModifying;
        private final RequestPredicate right;
        private final RequestModifyingPredicate rightModifying;

        public AndRequestPredicate(RequestPredicate left2, RequestPredicate right) {
            Assert.notNull((Object)left2, "Left RequestPredicate must not be null");
            Assert.notNull((Object)right, "Right RequestPredicate must not be null");
            this.left = left2;
            this.leftModifying = AndRequestPredicate.of(left2);
            this.right = right;
            this.rightModifying = AndRequestPredicate.of(right);
        }

        @Override
        protected RequestModifyingPredicate.Result testInternal(ServerRequest request) {
            ServerRequest rightRequest;
            RequestModifyingPredicate.Result leftResult = this.leftModifying.testInternal(request);
            if (!leftResult.value()) {
                return leftResult;
            }
            if (leftResult.modifiesAttributes()) {
                LinkedHashMap<String, Object> leftAttributes = new LinkedHashMap<String, Object>(2);
                leftResult.modifyAttributes(leftAttributes);
                rightRequest = new ExtendedAttributesServerRequestWrapper(request, leftAttributes);
            } else {
                rightRequest = request;
            }
            RequestModifyingPredicate.Result rightResult = this.rightModifying.testInternal(rightRequest);
            if (!rightResult.value()) {
                return rightResult;
            }
            return RequestModifyingPredicate.Result.of(true, attributes -> {
                leftResult.modifyAttributes((Map<String, Object>)attributes);
                rightResult.modifyAttributes((Map<String, Object>)attributes);
            });
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            return this.left.nest(request).flatMap(this.right::nest);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startAnd();
            this.left.accept(visitor);
            visitor.and();
            this.right.accept(visitor);
            visitor.endAnd();
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            ChangePathPatternParserVisitor.Target target2;
            RequestPredicate requestPredicate = this.left;
            if (requestPredicate instanceof ChangePathPatternParserVisitor.Target) {
                target2 = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target2.changeParser(parser);
            }
            if ((requestPredicate = this.right) instanceof ChangePathPatternParserVisitor.Target) {
                target2 = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target2.changeParser(parser);
            }
        }

        public String toString() {
            return String.format("(%s && %s)", this.left, this.right);
        }
    }

    private static abstract class RequestModifyingPredicate
    implements RequestPredicate {
        private RequestModifyingPredicate() {
        }

        public static RequestModifyingPredicate of(final RequestPredicate requestPredicate) {
            if (requestPredicate instanceof RequestModifyingPredicate) {
                RequestModifyingPredicate modifyingPredicate = (RequestModifyingPredicate)requestPredicate;
                return modifyingPredicate;
            }
            return new RequestModifyingPredicate(){

                @Override
                protected Result testInternal(ServerRequest request) {
                    return Result.of(requestPredicate.test(request));
                }
            };
        }

        @Override
        public final boolean test(ServerRequest request) {
            Result result2 = this.testInternal(request);
            boolean value2 = result2.value();
            if (value2) {
                result2.modifyAttributes(request.attributes());
            }
            return value2;
        }

        protected abstract Result testInternal(ServerRequest var1);

        protected static final class Result {
            private static final Result TRUE = new Result(true, null);
            private static final Result FALSE = new Result(false, null);
            private final boolean value;
            @Nullable
            private final Consumer<Map<String, Object>> modifyAttributes;

            private Result(boolean value2, @Nullable Consumer<Map<String, Object>> modifyAttributes) {
                this.value = value2;
                this.modifyAttributes = modifyAttributes;
            }

            public static Result of(boolean value2) {
                return Result.of(value2, null);
            }

            public static Result of(boolean value2, @Nullable Consumer<Map<String, Object>> modifyAttributes) {
                if (modifyAttributes == null) {
                    return value2 ? TRUE : FALSE;
                }
                return new Result(value2, modifyAttributes);
            }

            public boolean value() {
                return this.value;
            }

            public void modifyAttributes(Map<String, Object> attributes) {
                if (this.modifyAttributes != null) {
                    this.modifyAttributes.accept(attributes);
                }
            }

            public boolean modifiesAttributes() {
                return this.modifyAttributes != null;
            }
        }
    }

    public static interface Visitor {
        public void method(Set<HttpMethod> var1);

        public void path(String var1);

        public void pathExtension(String var1);

        public void header(String var1, String var2);

        public void param(String var1, String var2);

        public void startAnd();

        public void and();

        public void endAnd();

        public void startOr();

        public void or();

        public void endOr();

        public void startNegate();

        public void endNegate();

        public void unknown(RequestPredicate var1);
    }
}

