/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import jakarta.servlet.http.Cookie;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.function.DefaultRenderingResponseBuilder;
import org.springframework.web.servlet.function.ServerResponse;

public interface RenderingResponse
extends ServerResponse {
    public String name();

    public Map<String, Object> model();

    public static Builder from(RenderingResponse other) {
        return new DefaultRenderingResponseBuilder(other);
    }

    public static Builder create(String name2) {
        return new DefaultRenderingResponseBuilder(name2);
    }

    public static interface Builder {
        public Builder modelAttribute(Object var1);

        public Builder modelAttribute(String var1, @Nullable Object var2);

        public Builder modelAttributes(Object ... var1);

        public Builder modelAttributes(Collection<?> var1);

        public Builder modelAttributes(Map<String, ?> var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder status(HttpStatusCode var1);

        public Builder status(int var1);

        public Builder cookie(Cookie var1);

        public Builder cookies(Consumer<MultiValueMap<String, Cookie>> var1);

        public RenderingResponse build();
    }
}

