/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.server.PathContainer;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

class PathResourceLookupFunction
implements Function<ServerRequest, Optional<Resource>> {
    private final PathPattern pattern;
    private final Resource location;

    public PathResourceLookupFunction(String pattern, Resource location) {
        Assert.hasLength(pattern, "'pattern' must not be empty");
        Assert.notNull((Object)location, "'location' must not be null");
        this.pattern = PathPatternParser.defaultInstance.parse(pattern);
        this.location = location;
    }

    @Override
    public Optional<Resource> apply(ServerRequest request) {
        PathContainer pathContainer = request.requestPath().pathWithinApplication();
        if (!this.pattern.matches(pathContainer)) {
            return Optional.empty();
        }
        String path2 = this.processPath((pathContainer = this.pattern.extractPathWithinPattern(pathContainer)).value());
        if (path2.contains("%")) {
            path2 = StringUtils.uriDecode(path2, StandardCharsets.UTF_8);
        }
        if (!StringUtils.hasLength(path2) || this.isInvalidPath(path2)) {
            return Optional.empty();
        }
        try {
            Resource resource = this.location.createRelative(path2);
            if (resource.isReadable() && this.isResourceUnderLocation(resource)) {
                return Optional.of(resource);
            }
            return Optional.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private String processPath(String path2) {
        boolean slash = false;
        for (int i2 = 0; i2 < ((String)path2).length(); ++i2) {
            if (((String)path2).charAt(i2) == '/') {
                slash = true;
                continue;
            }
            if (((String)path2).charAt(i2) <= ' ' || ((String)path2).charAt(i2) == '\u007f') continue;
            if (i2 == 0 || i2 == 1 && slash) {
                return path2;
            }
            path2 = slash ? "/" + ((String)path2).substring(i2) : ((String)path2).substring(i2);
            return path2;
        }
        return slash ? "/" : "";
    }

    private boolean isInvalidPath(String path2) {
        if (path2.contains("WEB-INF") || path2.contains("META-INF")) {
            return true;
        }
        if (path2.contains(":/")) {
            String relativePath;
            String string2 = relativePath = path2.charAt(0) == '/' ? path2.substring(1) : path2;
            if (ResourceUtils.isUrl(relativePath) || relativePath.startsWith("url:")) {
                return true;
            }
        }
        return path2.contains("..") && StringUtils.cleanPath(path2).contains("../");
    }

    private boolean isResourceUnderLocation(Resource resource) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != this.location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath(this.location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            ClassPathResource classPathResource = (ClassPathResource)resource;
            resourcePath = classPathResource.getPath();
            locationPath = StringUtils.cleanPath(((ClassPathResource)this.location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath(this.location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        String string2 = locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        if (!resourcePath.startsWith(locationPath)) {
            return false;
        }
        return !resourcePath.contains("%") || !StringUtils.uriDecode(resourcePath, StandardCharsets.UTF_8).contains("../");
    }

    public String toString() {
        return this.pattern + " -> " + this.location;
    }
}

