/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.util.Assert;
import org.springframework.web.servlet.function.ErrorHandlingServerResponse;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

@FunctionalInterface
public interface HandlerFilterFunction<T extends ServerResponse, R extends ServerResponse> {
    public R filter(ServerRequest var1, HandlerFunction<T> var2) throws Exception;

    default public HandlerFilterFunction<T, R> andThen(HandlerFilterFunction<T, T> after) {
        Assert.notNull(after, "HandlerFilterFunction must not be null");
        return (request, next2) -> {
            HandlerFunction<ServerResponse> nextHandler = handlerRequest -> after.filter(handlerRequest, next2);
            return this.filter(request, nextHandler);
        };
    }

    default public HandlerFunction<R> apply(HandlerFunction<T> handler) {
        Assert.notNull(handler, "HandlerFunction must not be null");
        return request -> this.filter(request, handler);
    }

    public static <T extends ServerResponse> HandlerFilterFunction<T, T> ofRequestProcessor(Function<ServerRequest, ServerRequest> requestProcessor) {
        Assert.notNull(requestProcessor, "Function must not be null");
        return (request, next2) -> next2.handle((ServerRequest)requestProcessor.apply(request));
    }

    public static <T extends ServerResponse, R extends ServerResponse> HandlerFilterFunction<T, R> ofResponseProcessor(BiFunction<ServerRequest, T, R> responseProcessor) {
        Assert.notNull(responseProcessor, "Function must not be null");
        return (request, next2) -> (ServerResponse)responseProcessor.apply(request, next2.handle(request));
    }

    public static <T extends ServerResponse> HandlerFilterFunction<T, T> ofErrorHandler(Predicate<Throwable> predicate, BiFunction<Throwable, ServerRequest, T> errorHandler) {
        Assert.notNull(predicate, "Predicate must not be null");
        Assert.notNull(errorHandler, "ErrorHandler must not be null");
        return (request, next2) -> {
            try {
                Object t = next2.handle(request);
                if (t instanceof ErrorHandlingServerResponse) {
                    ErrorHandlingServerResponse response = (ErrorHandlingServerResponse)t;
                    response.addErrorHandler(predicate, errorHandler);
                }
                return t;
            }
            catch (Throwable throwable) {
                if (predicate.test(throwable)) {
                    return (ServerResponse)errorHandler.apply(throwable, request);
                }
                throw throwable;
            }
        };
    }
}

