/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.service.invoker.AbstractNamedValueArgumentResolver;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.ReactiveHttpRequestValues;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapter;

public class RequestPartArgumentResolver
extends AbstractNamedValueArgumentResolver {
    private static final boolean REACTOR_PRESENT = ClassUtils.isPresent("reactor.core.publisher.Mono", RequestPartArgumentResolver.class.getClassLoader());
    @Nullable
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public RequestPartArgumentResolver(HttpExchangeAdapter exchangeAdapter) {
        if (REACTOR_PRESENT) {
            ReactiveAdapterRegistry reactiveAdapterRegistry;
            if (exchangeAdapter instanceof ReactorHttpExchangeAdapter) {
                ReactorHttpExchangeAdapter reactorAdapter = (ReactorHttpExchangeAdapter)exchangeAdapter;
                reactiveAdapterRegistry = reactorAdapter.getReactiveAdapterRegistry();
            } else {
                reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
            }
            this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        } else {
            this.reactiveAdapterRegistry = null;
        }
    }

    @Override
    @Nullable
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        String label2;
        RequestPart annot = parameter.getParameterAnnotation(RequestPart.class);
        boolean isMultiPartFile = parameter.nestedIfOptional().getNestedParameterType().equals(MultipartFile.class);
        String string2 = label2 = isMultiPartFile ? "MultipartFile" : "request part";
        if (annot != null) {
            return new AbstractNamedValueArgumentResolver.NamedValueInfo(annot.name(), annot.required(), null, label2, true);
        }
        if (isMultiPartFile) {
            return new AbstractNamedValueArgumentResolver.NamedValueInfo("", true, null, label2, true);
        }
        return null;
    }

    @Override
    protected void addRequestValue(String name2, Object value2, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        Class<?> type2;
        ReactiveAdapter adapter;
        if (this.reactiveAdapterRegistry != null && (adapter = this.reactiveAdapterRegistry.getAdapter(type2 = parameter.getParameterType())) != null) {
            MethodParameter nestedParameter = parameter.nested();
            String message2 = "Async type for @RequestPart should produce value(s)";
            Assert.isTrue(!adapter.isNoValue(), message2);
            Assert.isTrue(nestedParameter.getNestedParameterType() != Void.class, message2);
            if (!(requestValues instanceof ReactiveHttpRequestValues.Builder)) {
                throw new IllegalStateException("RequestPart with a reactive type is only supported with reactive client");
            }
            ReactiveHttpRequestValues.Builder reactiveValues = (ReactiveHttpRequestValues.Builder)requestValues;
            reactiveValues.addRequestPartPublisher(name2, adapter.toPublisher(value2), RequestPartArgumentResolver.asParameterizedTypeRef(nestedParameter));
            return;
        }
        if (value2 instanceof MultipartFile) {
            MultipartFile multipartFile = (MultipartFile)value2;
            value2 = RequestPartArgumentResolver.toHttpEntity(name2, multipartFile);
        }
        requestValues.addRequestPart(name2, value2);
    }

    private static ParameterizedTypeReference<Object> asParameterizedTypeRef(MethodParameter nestedParam) {
        return ParameterizedTypeReference.forType(nestedParam.getNestedGenericParameterType());
    }

    private static Object toHttpEntity(String name2, MultipartFile multipartFile) {
        HttpHeaders headers = new HttpHeaders();
        if (multipartFile.getOriginalFilename() != null) {
            headers.setContentDispositionFormData(name2, multipartFile.getOriginalFilename());
        }
        if (multipartFile.getContentType() != null) {
            headers.add("Content-Type", multipartFile.getContentType());
        }
        return new HttpEntity<Resource>(multipartFile.getResource(), headers);
    }
}

