/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.session;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpCookie;
import org.springframework.http.ResponseCookie;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.session.WebSessionIdResolver;

public class CookieWebSessionIdResolver
implements WebSessionIdResolver {
    private String cookieName = "SESSION";
    private Duration cookieMaxAge = Duration.ofSeconds(-1L);
    @Nullable
    private Consumer<ResponseCookie.ResponseCookieBuilder> initializer = null;

    public void setCookieName(String cookieName) {
        Assert.hasText(cookieName, "'cookieName' must not be empty");
        this.cookieName = cookieName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieMaxAge(Duration maxAge) {
        this.cookieMaxAge = maxAge;
    }

    public Duration getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void addCookieInitializer(Consumer<ResponseCookie.ResponseCookieBuilder> initializer) {
        this.initializer = this.initializer != null ? this.initializer.andThen(initializer) : initializer;
    }

    @Override
    public List<String> resolveSessionIds(ServerWebExchange exchange2) {
        MultiValueMap<String, HttpCookie> cookieMap = exchange2.getRequest().getCookies();
        List cookies = (List)cookieMap.get(this.getCookieName());
        if (cookies == null) {
            return Collections.emptyList();
        }
        return cookies.stream().map(HttpCookie::getValue).toList();
    }

    @Override
    public void setSessionId(ServerWebExchange exchange2, String id2) {
        Assert.notNull((Object)id2, "'id' is required");
        ResponseCookie cookie = this.initCookie(exchange2, id2).build();
        exchange2.getResponse().getCookies().set(this.cookieName, cookie);
    }

    @Override
    public void expireSession(ServerWebExchange exchange2) {
        ResponseCookie cookie = this.initCookie(exchange2, "").maxAge(0L).build();
        exchange2.getResponse().getCookies().set(this.cookieName, cookie);
    }

    private ResponseCookie.ResponseCookieBuilder initCookie(ServerWebExchange exchange2, String id2) {
        ResponseCookie.ResponseCookieBuilder builder = ResponseCookie.from(this.cookieName, id2).path(exchange2.getRequest().getPath().contextPath().value() + "/").maxAge(this.getCookieMaxAge()).httpOnly(true).secure("https".equalsIgnoreCase(exchange2.getRequest().getURI().getScheme())).sameSite("Lax");
        if (this.initializer != null) {
            this.initializer.accept(builder);
        }
        return builder;
    }
}

