/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.handler;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;

public class DefaultWebFilterChain
implements WebFilterChain {
    private final List<WebFilter> allFilters;
    private final WebHandler handler;
    @Nullable
    private final WebFilter currentFilter;
    @Nullable
    private final DefaultWebFilterChain chain;

    public DefaultWebFilterChain(WebHandler handler, List<WebFilter> filters) {
        Assert.notNull((Object)handler, "WebHandler is required");
        this.allFilters = Collections.unmodifiableList(filters);
        this.handler = handler;
        DefaultWebFilterChain chain2 = DefaultWebFilterChain.initChain(filters, handler);
        this.currentFilter = chain2.currentFilter;
        this.chain = chain2.chain;
    }

    private static DefaultWebFilterChain initChain(List<WebFilter> filters, WebHandler handler) {
        DefaultWebFilterChain chain2 = new DefaultWebFilterChain(filters, handler, null, null);
        ListIterator<WebFilter> iterator = filters.listIterator(filters.size());
        while (iterator.hasPrevious()) {
            chain2 = new DefaultWebFilterChain(filters, handler, iterator.previous(), chain2);
        }
        return chain2;
    }

    private DefaultWebFilterChain(List<WebFilter> allFilters, WebHandler handler, @Nullable WebFilter currentFilter, @Nullable DefaultWebFilterChain chain2) {
        this.allFilters = allFilters;
        this.currentFilter = currentFilter;
        this.handler = handler;
        this.chain = chain2;
    }

    public List<WebFilter> getFilters() {
        return this.allFilters;
    }

    public WebHandler getHandler() {
        return this.handler;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2) {
        return Mono.defer(() -> this.currentFilter != null && this.chain != null ? this.invokeFilter(this.currentFilter, this.chain, exchange2) : this.handler.handle(exchange2));
    }

    private Mono<Void> invokeFilter(WebFilter current2, DefaultWebFilterChain chain2, ServerWebExchange exchange2) {
        String currentName = current2.getClass().getName();
        return current2.filter(exchange2, chain2).checkpoint(currentName + " [DefaultWebFilterChain]");
    }
}

