/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.lang.Nullable;
import org.springframework.web.ErrorResponseException;

public class ResponseStatusException
extends ErrorResponseException {
    @Nullable
    private final String reason;

    public ResponseStatusException(HttpStatusCode status2) {
        this(status2, (String)null);
    }

    public ResponseStatusException(HttpStatusCode status2, @Nullable String reason2) {
        this(status2, reason2, null);
    }

    public ResponseStatusException(int rawStatusCode, @Nullable String reason2, @Nullable Throwable cause2) {
        this(HttpStatusCode.valueOf(rawStatusCode), reason2, cause2);
    }

    public ResponseStatusException(HttpStatusCode status2, @Nullable String reason2, @Nullable Throwable cause2) {
        this(status2, reason2, cause2, null, null);
    }

    protected ResponseStatusException(HttpStatusCode status2, @Nullable String reason2, @Nullable Throwable cause2, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        super(status2, ProblemDetail.forStatus(status2), cause2, messageDetailCode, messageDetailArguments);
        this.reason = reason2;
        this.setDetail(reason2);
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.getResponseHeaders();
    }

    @Deprecated(since="6.0")
    public HttpHeaders getResponseHeaders() {
        return HttpHeaders.EMPTY;
    }

    @Override
    public ProblemDetail updateAndGetBody(@Nullable MessageSource messageSource, Locale locale) {
        super.updateAndGetBody(messageSource, locale);
        if (messageSource != null && this.getReason() != null && this.getReason().equals(this.getBody().getDetail())) {
            Object[] arguments = this.getDetailMessageArguments(messageSource, locale);
            String resolved = messageSource.getMessage(this.getReason(), arguments, null, locale);
            if (resolved != null) {
                this.getBody().setDetail(resolved);
            }
        }
        return this.getBody();
    }

    @Override
    public String getMessage() {
        return this.getStatusCode() + (String)(this.reason != null ? " \"" + this.reason + "\"" : "");
    }
}

