/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.context.MessageSource;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.method.MethodValidator;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.ModelAndViewContainer;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class<?>[] EMPTY_GROUPS = new Class[0];
    private HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    @Nullable
    private WebDataBinderFactory dataBinderFactory;
    @Nullable
    private MethodValidator methodValidator;
    private Class<?>[] validationGroups = EMPTY_GROUPS;

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean2, Method method2) {
        super(bean2, method2);
    }

    protected InvocableHandlerMethod(Object bean2, Method method2, @Nullable MessageSource messageSource) {
        super(bean2, method2, messageSource);
    }

    public InvocableHandlerMethod(Object bean2, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        super(bean2, methodName, parameterTypes);
    }

    public void setHandlerMethodArgumentResolvers(HandlerMethodArgumentResolverComposite argumentResolvers) {
        this.resolvers = argumentResolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setDataBinderFactory(WebDataBinderFactory dataBinderFactory) {
        this.dataBinderFactory = dataBinderFactory;
    }

    public void setMethodValidator(@Nullable MethodValidator methodValidator) {
        this.methodValidator = methodValidator;
        this.validationGroups = methodValidator != null ? methodValidator.determineValidationGroups(this.getBean(), this.getBridgedMethod()) : EMPTY_GROUPS;
    }

    @Nullable
    public Object invokeForRequest(NativeWebRequest request, @Nullable ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        Object[] args2 = this.getMethodArgumentValues(request, mavContainer, providedArgs);
        if (logger.isTraceEnabled()) {
            logger.trace("Arguments: " + Arrays.toString(args2));
        }
        if (this.shouldValidateArguments() && this.methodValidator != null) {
            this.methodValidator.applyArgumentValidation(this.getBean(), this.getBridgedMethod(), this.getMethodParameters(), args2, this.validationGroups);
        }
        Object returnValue = this.doInvoke(args2);
        if (this.shouldValidateReturnValue() && this.methodValidator != null) {
            this.methodValidator.applyReturnValueValidation(this.getBean(), this.getBridgedMethod(), this.getReturnType(), returnValue, this.validationGroups);
        }
        return returnValue;
    }

    protected Object[] getMethodArgumentValues(NativeWebRequest request, @Nullable ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        Object[] parameters2 = this.getMethodParameters();
        if (ObjectUtils.isEmpty(parameters2)) {
            return EMPTY_ARGS;
        }
        Object[] args2 = new Object[parameters2.length];
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            Object parameter = parameters2[i2];
            ((MethodParameter)parameter).initParameterNameDiscovery(this.parameterNameDiscoverer);
            args2[i2] = InvocableHandlerMethod.findProvidedArgument((MethodParameter)parameter, providedArgs);
            if (args2[i2] != null) continue;
            if (!this.resolvers.supportsParameter((MethodParameter)parameter)) {
                throw new IllegalStateException(InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, "No suitable resolver"));
            }
            try {
                args2[i2] = this.resolvers.resolveArgument((MethodParameter)parameter, mavContainer, request, this.dataBinderFactory);
                continue;
            }
            catch (Exception ex) {
                String exMsg;
                if (logger.isDebugEnabled() && (exMsg = ex.getMessage()) != null && !exMsg.contains(((MethodParameter)parameter).getExecutable().toGenericString())) {
                    logger.debug(InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, exMsg));
                }
                throw ex;
            }
        }
        return args2;
    }

    @Nullable
    protected Object doInvoke(Object ... args2) throws Exception {
        Method method2 = this.getBridgedMethod();
        try {
            if (KotlinDetector.isKotlinReflectPresent()) {
                if (KotlinDetector.isSuspendingFunction(method2)) {
                    return this.invokeSuspendingFunction(method2, this.getBean(), args2);
                }
                if (KotlinDetector.isKotlinType(method2.getDeclaringClass())) {
                    return KotlinDelegate.invokeFunction(method2, this.getBean(), args2);
                }
            }
            return method2.invoke(this.getBean(), args2);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(method2, this.getBean(), args2);
            String text = ex.getMessage() == null || ex.getCause() instanceof NullPointerException ? "Illegal argument" : ex.getMessage();
            throw new IllegalStateException(this.formatInvokeError(text, args2), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getCause();
            if (targetException instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)targetException;
                throw runtimeException;
            }
            if (targetException instanceof Error) {
                Error error2 = (Error)targetException;
                throw error2;
            }
            if (targetException instanceof Exception) {
                Exception exception2 = (Exception)targetException;
                throw exception2;
            }
            throw new IllegalStateException(this.formatInvokeError("Invocation failure", args2), targetException);
        }
    }

    protected Object invokeSuspendingFunction(Method method2, Object target2, Object[] args2) {
        return CoroutinesUtils.invokeSuspendingFunction(method2, target2, args2);
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        @Nullable
        public static Object invokeFunction(Method method2, Object target2, Object[] args2) throws InvocationTargetException, IllegalAccessException {
            KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method2);
            if (function == null) {
                return method2.invoke(target2, args2);
            }
            if (method2.isAccessible() && !KCallablesJvm.isAccessible((KCallable)function)) {
                KCallablesJvm.setAccessible((KCallable)function, (boolean)true);
            }
            HashMap<KParameter, Object> argMap = CollectionUtils.newHashMap(args2.length + 1);
            int index2 = 0;
            for (KParameter parameter : function.getParameters()) {
                switch (parameter.getKind()) {
                    case INSTANCE: {
                        argMap.put(parameter, target2);
                        break;
                    }
                    case VALUE: 
                    case EXTENSION_RECEIVER: {
                        Object arg2 = args2[index2];
                        if (!parameter.isOptional() || arg2 != null) {
                            KClass kClass;
                            KClassifier kClassifier;
                            KType type2 = parameter.getType();
                            if ((!type2.isMarkedNullable() || arg2 != null) && (kClassifier = type2.getClassifier()) instanceof KClass && KotlinDetector.isInlineClass(JvmClassMappingKt.getJavaClass((KClass)(kClass = (KClass)kClassifier)))) {
                                KFunction constructor2 = KClasses.getPrimaryConstructor((KClass)kClass);
                                if (!KCallablesJvm.isAccessible((KCallable)constructor2)) {
                                    KCallablesJvm.setAccessible((KCallable)constructor2, (boolean)true);
                                }
                                arg2 = constructor2.call(new Object[]{arg2});
                            }
                            argMap.put(parameter, arg2);
                        }
                        ++index2;
                    }
                }
            }
            Object result2 = function.callBy(argMap);
            return result2 == Unit.INSTANCE ? null : result2;
        }
    }
}

