/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.MethodValidationAdapter;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.validation.method.MethodValidator;
import org.springframework.validation.method.ParameterErrors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.annotation.HandlerMethodValidationException;
import org.springframework.web.method.annotation.ModelFactory;

public final class HandlerMethodValidator
implements MethodValidator {
    private static final MethodValidationAdapter.ObjectNameResolver objectNameResolver = new WebObjectNameResolver();
    private final MethodValidationAdapter validationAdapter;
    private final Predicate<MethodParameter> modelAttributePredicate;
    private final Predicate<MethodParameter> requestParamPredicate;

    private HandlerMethodValidator(MethodValidationAdapter validationAdapter, Predicate<MethodParameter> modelAttributePredicate, Predicate<MethodParameter> requestParamPredicate) {
        this.validationAdapter = validationAdapter;
        this.modelAttributePredicate = modelAttributePredicate;
        this.requestParamPredicate = requestParamPredicate;
    }

    @Override
    public Class<?>[] determineValidationGroups(Object target2, Method method2) {
        return this.validationAdapter.determineValidationGroups(target2, method2);
    }

    @Override
    public void applyArgumentValidation(Object target2, Method method2, @Nullable MethodParameter[] parameters2, Object[] arguments, Class<?>[] groups2) {
        MethodValidationResult result2 = this.validateArguments(target2, method2, parameters2, arguments, groups2);
        if (!result2.hasErrors()) {
            return;
        }
        if (!result2.getBeanResults().isEmpty()) {
            int bindingResultCount = 0;
            block0: for (ParameterErrors errors : result2.getBeanResults()) {
                for (Object arg2 : arguments) {
                    BindingResult bindingResult;
                    if (!(arg2 instanceof BindingResult) || !(bindingResult = (BindingResult)arg2).getObjectName().equals(errors.getObjectName())) continue;
                    bindingResult.addAllErrors(errors);
                    ++bindingResultCount;
                    continue block0;
                }
            }
            if (result2.getAllValidationResults().size() == bindingResultCount) {
                return;
            }
        }
        throw new HandlerMethodValidationException(result2, this.modelAttributePredicate, this.requestParamPredicate);
    }

    @Override
    public MethodValidationResult validateArguments(Object target2, Method method2, @Nullable MethodParameter[] parameters2, Object[] arguments, Class<?>[] groups2) {
        return this.validationAdapter.validateArguments(target2, method2, parameters2, arguments, groups2);
    }

    @Override
    public void applyReturnValueValidation(Object target2, Method method2, @Nullable MethodParameter returnType, @Nullable Object returnValue, Class<?>[] groups2) {
        MethodValidationResult result2 = this.validateReturnValue(target2, method2, returnType, returnValue, groups2);
        if (result2.hasErrors()) {
            throw new HandlerMethodValidationException(result2);
        }
    }

    @Override
    public MethodValidationResult validateReturnValue(Object target2, Method method2, @Nullable MethodParameter returnType, @Nullable Object returnValue, Class<?>[] groups2) {
        return this.validationAdapter.validateReturnValue(target2, method2, returnType, returnValue, groups2);
    }

    @Nullable
    public static MethodValidator from(@Nullable WebBindingInitializer initializer, @Nullable ParameterNameDiscoverer paramNameDiscoverer, Predicate<MethodParameter> modelAttributePredicate, Predicate<MethodParameter> requestParamPredicate) {
        ConfigurableWebBindingInitializer configurableInitializer;
        jakarta.validation.Validator validator;
        if (initializer instanceof ConfigurableWebBindingInitializer && (validator = HandlerMethodValidator.getValidator(configurableInitializer = (ConfigurableWebBindingInitializer)initializer)) != null) {
            MessageCodesResolver codesResolver;
            MethodValidationAdapter adapter = new MethodValidationAdapter(validator);
            adapter.setObjectNameResolver(objectNameResolver);
            if (paramNameDiscoverer != null) {
                adapter.setParameterNameDiscoverer(paramNameDiscoverer);
            }
            if ((codesResolver = configurableInitializer.getMessageCodesResolver()) != null) {
                adapter.setMessageCodesResolver(codesResolver);
            }
            return new HandlerMethodValidator(adapter, modelAttributePredicate, requestParamPredicate);
        }
        return null;
    }

    @Nullable
    private static jakarta.validation.Validator getValidator(ConfigurableWebBindingInitializer initializer) {
        Validator validator = initializer.getValidator();
        if (validator instanceof jakarta.validation.Validator) {
            jakarta.validation.Validator validator2 = (jakarta.validation.Validator)validator;
            return validator2;
        }
        validator = initializer.getValidator();
        if (validator instanceof SmartValidator) {
            SmartValidator smartValidator = (SmartValidator)validator;
            return smartValidator.unwrap(jakarta.validation.Validator.class);
        }
        return null;
    }

    private static class WebObjectNameResolver
    implements MethodValidationAdapter.ObjectNameResolver {
        private WebObjectNameResolver() {
        }

        @Override
        public String resolveName(MethodParameter param, @Nullable Object value2) {
            if (param.hasParameterAnnotation(RequestBody.class) || param.hasParameterAnnotation(RequestPart.class)) {
                return Conventions.getVariableNameForParameter(param);
            }
            return param.getParameterIndex() != -1 ? ModelFactory.getNameForParameter(param) : ModelFactory.getNameForReturnValue(value2, param);
        }
    }
}

