/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import jakarta.servlet.ServletException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.method.annotation.MethodArgumentConversionNotSupportedException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class AbstractNamedValueMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Nullable
    private final ConfigurableBeanFactory configurableBeanFactory;
    @Nullable
    private final BeanExpressionContext expressionContext;
    private final Map<MethodParameter, NamedValueInfo> namedValueInfoCache = new ConcurrentHashMap<MethodParameter, NamedValueInfo>(256);

    public AbstractNamedValueMethodArgumentResolver() {
        this.configurableBeanFactory = null;
        this.expressionContext = null;
    }

    public AbstractNamedValueMethodArgumentResolver(@Nullable ConfigurableBeanFactory beanFactory) {
        this.configurableBeanFactory = beanFactory;
        this.expressionContext = beanFactory != null ? new BeanExpressionContext(beanFactory, new RequestScope()) : null;
    }

    @Override
    @Nullable
    public final Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        NamedValueInfo namedValueInfo = this.getNamedValueInfo(parameter);
        MethodParameter nestedParameter = parameter.nestedIfOptional();
        boolean hasDefaultValue = KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(parameter.getDeclaringClass()) && KotlinDelegate.hasDefaultValue(nestedParameter);
        Object resolvedName = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.name);
        if (resolvedName == null) {
            throw new IllegalArgumentException("Specified name must not resolve to null: [" + namedValueInfo.name + "]");
        }
        Object arg2 = this.resolveName(resolvedName.toString(), nestedParameter, webRequest);
        if (arg2 == null) {
            if (namedValueInfo.defaultValue != null) {
                arg2 = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.defaultValue);
            } else if (namedValueInfo.required && !nestedParameter.isOptional()) {
                this.handleMissingValue(namedValueInfo.name, nestedParameter, webRequest);
            }
            if (!hasDefaultValue) {
                arg2 = this.handleNullValue(namedValueInfo.name, arg2, nestedParameter.getNestedParameterType());
            }
        } else if ("".equals(arg2) && namedValueInfo.defaultValue != null) {
            arg2 = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.defaultValue);
        }
        if (!(binderFactory == null || arg2 == null && hasDefaultValue || (arg2 = AbstractNamedValueMethodArgumentResolver.convertIfNecessary(parameter, webRequest, binderFactory, namedValueInfo, arg2)) != null)) {
            if (namedValueInfo.defaultValue != null) {
                arg2 = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.defaultValue);
                arg2 = AbstractNamedValueMethodArgumentResolver.convertIfNecessary(parameter, webRequest, binderFactory, namedValueInfo, arg2);
            } else if (namedValueInfo.required && !nestedParameter.isOptional()) {
                this.handleMissingValueAfterConversion(namedValueInfo.name, nestedParameter, webRequest);
            }
        }
        this.handleResolvedValue(arg2, namedValueInfo.name, parameter, mavContainer, webRequest);
        return arg2;
    }

    private NamedValueInfo getNamedValueInfo(MethodParameter parameter) {
        NamedValueInfo namedValueInfo = this.namedValueInfoCache.get(parameter);
        if (namedValueInfo == null) {
            namedValueInfo = this.createNamedValueInfo(parameter);
            namedValueInfo = this.updateNamedValueInfo(parameter, namedValueInfo);
            this.namedValueInfoCache.put(parameter, namedValueInfo);
        }
        return namedValueInfo;
    }

    protected abstract NamedValueInfo createNamedValueInfo(MethodParameter var1);

    private NamedValueInfo updateNamedValueInfo(MethodParameter parameter, NamedValueInfo info) {
        String name2 = info.name;
        if (info.name.isEmpty() && (name2 = parameter.getParameterName()) == null) {
            throw new IllegalArgumentException("Name for argument of type [%s] not specified, and parameter name information not available via reflection. Ensure that the compiler uses the '-parameters' flag.".formatted(parameter.getNestedParameterType().getName()));
        }
        String defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(info.defaultValue) ? null : info.defaultValue;
        return new NamedValueInfo(name2, info.required, defaultValue);
    }

    @Nullable
    private Object resolveEmbeddedValuesAndExpressions(String value2) {
        if (this.configurableBeanFactory == null || this.expressionContext == null) {
            return value2;
        }
        String placeholdersResolved = this.configurableBeanFactory.resolveEmbeddedValue(value2);
        BeanExpressionResolver exprResolver = this.configurableBeanFactory.getBeanExpressionResolver();
        if (exprResolver == null) {
            return value2;
        }
        return exprResolver.evaluate(placeholdersResolved, this.expressionContext);
    }

    @Nullable
    protected abstract Object resolveName(String var1, MethodParameter var2, NativeWebRequest var3) throws Exception;

    protected void handleMissingValue(String name2, MethodParameter parameter, NativeWebRequest request) throws Exception {
        this.handleMissingValue(name2, parameter);
    }

    protected void handleMissingValue(String name2, MethodParameter parameter) throws ServletException {
        throw new ServletRequestBindingException("Missing argument '" + name2 + "' for method parameter of type " + parameter.getNestedParameterType().getSimpleName());
    }

    protected void handleMissingValueAfterConversion(String name2, MethodParameter parameter, NativeWebRequest request) throws Exception {
        this.handleMissingValue(name2, parameter, request);
    }

    @Nullable
    private Object handleNullValue(String name2, @Nullable Object value2, Class<?> paramType) {
        if (value2 == null) {
            if (paramType == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (paramType.isPrimitive()) {
                throw new IllegalStateException("Optional " + paramType.getSimpleName() + " parameter '" + name2 + "' is present but cannot be translated into a null value due to being declared as a primitive type. Consider declaring it as object wrapper for the corresponding primitive type.");
            }
        }
        return value2;
    }

    @Nullable
    private static Object convertIfNecessary(MethodParameter parameter, NativeWebRequest webRequest, WebDataBinderFactory binderFactory, NamedValueInfo namedValueInfo, @Nullable Object arg2) throws Exception {
        Constructor<?> ctor;
        WebDataBinder binder = binderFactory.createBinder(webRequest, null, namedValueInfo.name);
        Class<?> parameterType = parameter.getParameterType();
        if (KotlinDetector.isKotlinPresent() && KotlinDetector.isInlineClass(parameterType) && (ctor = BeanUtils.findPrimaryConstructor(parameterType)) != null) {
            parameterType = ctor.getParameterTypes()[0];
        }
        try {
            arg2 = binder.convertIfNecessary(arg2, parameterType, parameter);
        }
        catch (ConversionNotSupportedException ex) {
            throw new MethodArgumentConversionNotSupportedException(arg2, ex.getRequiredType(), namedValueInfo.name, parameter, ex.getCause());
        }
        catch (TypeMismatchException ex) {
            throw new MethodArgumentTypeMismatchException(arg2, ex.getRequiredType(), namedValueInfo.name, parameter, ex.getCause());
        }
        return arg2;
    }

    protected void handleResolvedValue(@Nullable Object arg2, String name2, MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest) {
    }

    protected static class NamedValueInfo {
        private final String name;
        private final boolean required;
        @Nullable
        private final String defaultValue;

        public NamedValueInfo(String name2, boolean required, @Nullable String defaultValue) {
            this.name = name2;
            this.required = required;
            this.defaultValue = defaultValue;
        }
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static boolean hasDefaultValue(MethodParameter parameter) {
            Method method2 = Objects.requireNonNull(parameter.getMethod());
            KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method2);
            if (function != null) {
                int index2 = 0;
                for (KParameter kParameter : function.getParameters()) {
                    if (!KParameter.Kind.VALUE.equals((Object)kParameter.getKind()) || parameter.getParameterIndex() != index2++) continue;
                    return kParameter.isOptional();
                }
            }
            return false;
        }
    }
}

