/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.filter.RelativeRedirectResponseWrapper;

public class RelativeRedirectFilter
extends OncePerRequestFilter {
    private HttpStatusCode redirectStatus = HttpStatus.SEE_OTHER;

    public void setRedirectStatus(HttpStatusCode status2) {
        Assert.notNull((Object)status2, "Property 'redirectStatus' is required");
        Assert.isTrue(status2.is3xxRedirection(), () -> "Not a redirect status code: " + status2);
        this.redirectStatus = status2;
    }

    public HttpStatusCode getRedirectStatus() {
        return this.redirectStatus;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        response = RelativeRedirectResponseWrapper.wrapIfNecessary(response, this.redirectStatus);
        filterChain.doFilter(request, response);
    }
}

