/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class CharacterEncodingFilter
extends OncePerRequestFilter {
    @Nullable
    private String encoding;
    private boolean forceRequestEncoding = false;
    private boolean forceResponseEncoding = false;

    public CharacterEncodingFilter() {
    }

    public CharacterEncodingFilter(String encoding2) {
        this(encoding2, false);
    }

    public CharacterEncodingFilter(String encoding2, boolean forceEncoding) {
        this(encoding2, forceEncoding, forceEncoding);
    }

    public CharacterEncodingFilter(String encoding2, boolean forceRequestEncoding, boolean forceResponseEncoding) {
        Assert.hasLength(encoding2, "Encoding must not be empty");
        this.encoding = encoding2;
        this.forceRequestEncoding = forceRequestEncoding;
        this.forceResponseEncoding = forceResponseEncoding;
    }

    public void setEncoding(@Nullable String encoding2) {
        this.encoding = encoding2;
    }

    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    public void setForceEncoding(boolean forceEncoding) {
        this.forceRequestEncoding = forceEncoding;
        this.forceResponseEncoding = forceEncoding;
    }

    public void setForceRequestEncoding(boolean forceRequestEncoding) {
        this.forceRequestEncoding = forceRequestEncoding;
    }

    public boolean isForceRequestEncoding() {
        return this.forceRequestEncoding;
    }

    public void setForceResponseEncoding(boolean forceResponseEncoding) {
        this.forceResponseEncoding = forceResponseEncoding;
    }

    public boolean isForceResponseEncoding() {
        return this.forceResponseEncoding;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String encoding2 = this.getEncoding();
        if (encoding2 != null) {
            if (this.isForceRequestEncoding() || request.getCharacterEncoding() == null) {
                request.setCharacterEncoding(encoding2);
            }
            if (this.isForceResponseEncoding()) {
                response.setCharacterEncoding(encoding2);
            }
        }
        filterChain.doFilter(request, response);
    }
}

