/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.HashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class ContextExposingHttpServletRequest
extends HttpServletRequestWrapper {
    private final WebApplicationContext webApplicationContext;
    @Nullable
    private final Set<String> exposedContextBeanNames;
    @Nullable
    private Set<String> explicitAttributes;

    public ContextExposingHttpServletRequest(HttpServletRequest originalRequest, WebApplicationContext context) {
        this(originalRequest, context, null);
    }

    public ContextExposingHttpServletRequest(HttpServletRequest originalRequest, WebApplicationContext context, @Nullable Set<String> exposedContextBeanNames) {
        super(originalRequest);
        Assert.notNull((Object)context, "WebApplicationContext must not be null");
        this.webApplicationContext = context;
        this.exposedContextBeanNames = exposedContextBeanNames;
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    @Override
    @Nullable
    public Object getAttribute(String name2) {
        if (!(this.explicitAttributes != null && this.explicitAttributes.contains(name2) || this.exposedContextBeanNames != null && !this.exposedContextBeanNames.contains(name2) || !this.webApplicationContext.containsBean(name2))) {
            return this.webApplicationContext.getBean(name2);
        }
        return super.getAttribute(name2);
    }

    @Override
    public void setAttribute(String name2, Object value2) {
        super.setAttribute(name2, value2);
        if (this.explicitAttributes == null) {
            this.explicitAttributes = new HashSet<String>(8);
        }
        this.explicitAttributes.add(name2);
    }
}

