/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

public class RestClientResponseException
extends RestClientException {
    private static final long serialVersionUID = -8803556342728481792L;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final HttpStatusCode statusCode;
    private final String statusText;
    private final byte[] responseBody;
    @Nullable
    private final HttpHeaders responseHeaders;
    @Nullable
    private final String responseCharset;
    @Nullable
    private transient Function<ResolvableType, ?> bodyConvertFunction;

    public RestClientResponseException(String message2, int statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        this(message2, HttpStatusCode.valueOf(statusCode), statusText, headers, responseBody, responseCharset);
    }

    public RestClientResponseException(String message2, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        super(message2);
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.responseHeaders = RestClientResponseException.copyHeaders(headers);
        this.responseBody = responseBody != null ? responseBody : new byte[]{};
        this.responseCharset = responseCharset != null ? responseCharset.name() : null;
    }

    @Nullable
    private static HttpHeaders copyHeaders(@Nullable HttpHeaders headers) {
        if (headers != null) {
            MultiValueMap<String, String> result2 = CollectionUtils.toMultiValueMap(new LinkedCaseInsensitiveMap(headers.size(), Locale.ENGLISH));
            headers.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(name2, values2) -> values2.forEach(value2 -> result2.add((String)name2, (String)value2))));
            return HttpHeaders.readOnlyHttpHeaders(result2);
        }
        return null;
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    @Deprecated(since="6.0")
    public int getRawStatusCode() {
        return this.statusCode.value();
    }

    public String getStatusText() {
        return this.statusText;
    }

    @Nullable
    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public byte[] getResponseBodyAsByteArray() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return this.getResponseBodyAsString(DEFAULT_CHARSET);
    }

    public String getResponseBodyAsString(Charset fallbackCharset) {
        if (this.responseCharset == null) {
            return new String(this.responseBody, fallbackCharset);
        }
        try {
            return new String(this.responseBody, this.responseCharset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Nullable
    public <E> E getResponseBodyAs(Class<E> targetType) {
        return this.getResponseBodyAs(ResolvableType.forClass(targetType));
    }

    @Nullable
    public <E> E getResponseBodyAs(ParameterizedTypeReference<E> targetType) {
        return this.getResponseBodyAs(ResolvableType.forType(targetType.getType()));
    }

    @Nullable
    private <E> E getResponseBodyAs(ResolvableType targetType) {
        Assert.state(this.bodyConvertFunction != null, "Function to convert body not set");
        return (E)this.bodyConvertFunction.apply(targetType);
    }

    public void setBodyConvertFunction(Function<ResolvableType, ?> bodyConvertFunction) {
        this.bodyConvertFunction = bodyConvertFunction;
    }
}

