/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.nio.charset.Charset;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientResponseException;

public abstract class HttpStatusCodeException
extends RestClientResponseException {
    private static final long serialVersionUID = 5696801857651587810L;

    protected HttpStatusCodeException(HttpStatusCode statusCode) {
        this(statusCode, HttpStatusCodeException.name(statusCode), null, null, null);
    }

    private static String name(HttpStatusCode statusCode) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status2 = (HttpStatus)statusCode;
            return status2.name();
        }
        return "";
    }

    protected HttpStatusCodeException(HttpStatusCode statusCode, String statusText) {
        this(statusCode, statusText, null, null, null);
    }

    protected HttpStatusCodeException(HttpStatusCode statusCode, String statusText, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        this(statusCode, statusText, null, responseBody, responseCharset);
    }

    protected HttpStatusCodeException(HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders responseHeaders, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        this(HttpStatusCodeException.getMessage(statusCode, statusText), statusCode, statusText, responseHeaders, responseBody, responseCharset);
    }

    protected HttpStatusCodeException(String message2, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders responseHeaders, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        super(message2, statusCode, statusText, responseHeaders, responseBody, responseCharset);
    }

    private static String getMessage(HttpStatusCode statusCode, String statusText) {
        if (!StringUtils.hasLength(statusText) && statusCode instanceof HttpStatus) {
            HttpStatus status2 = (HttpStatus)statusCode;
            statusText = status2.getReasonPhrase();
        }
        return statusCode.value() + " " + statusText;
    }
}

