/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.core.MethodParameter;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.DataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebExchangeDataBinder
extends WebDataBinder {
    public WebExchangeDataBinder(@Nullable Object target2) {
        super(target2);
    }

    public WebExchangeDataBinder(@Nullable Object target2, String objectName) {
        super(target2, objectName);
    }

    public Mono<Void> construct(ServerWebExchange exchange2) {
        return this.getValuesToBind(exchange2).doOnNext(map2 -> this.construct(new MapValueResolver((Map<String, Object>)map2))).then();
    }

    @Override
    protected boolean shouldConstructArgument(MethodParameter param) {
        Class<?> type2 = param.nestedIfOptional().getNestedParameterType();
        return super.shouldConstructArgument(param) && !Part.class.isAssignableFrom(type2);
    }

    public Mono<Void> bind(ServerWebExchange exchange2) {
        if (this.shouldNotBindPropertyValues()) {
            return Mono.empty();
        }
        return this.getValuesToBind(exchange2).doOnNext(map2 -> this.doBind(new MutablePropertyValues((Map<?, ?>)map2))).then();
    }

    public Mono<Map<String, Object>> getValuesToBind(ServerWebExchange exchange2) {
        return WebExchangeDataBinder.extractValuesToBind(exchange2);
    }

    public static Mono<Map<String, Object>> extractValuesToBind(ServerWebExchange exchange2) {
        MultiValueMap<String, String> queryParams = exchange2.getRequest().getQueryParams();
        Mono<MultiValueMap<String, String>> formData = exchange2.getFormData();
        Mono<MultiValueMap<String, Part>> multipartData = exchange2.getMultipartData();
        return Mono.zip((Mono)Mono.just(queryParams), formData, multipartData).map(tuple -> {
            TreeMap result2 = new TreeMap();
            ((MultiValueMap)tuple.getT1()).forEach((key2, values2) -> WebExchangeDataBinder.addBindValue(result2, key2, values2));
            ((MultiValueMap)tuple.getT2()).forEach((key2, values2) -> WebExchangeDataBinder.addBindValue(result2, key2, values2));
            ((MultiValueMap)tuple.getT3()).forEach((key2, values2) -> WebExchangeDataBinder.addBindValue(result2, key2, values2));
            return result2;
        });
    }

    protected static void addBindValue(Map<String, Object> params2, String key2, List<?> values2) {
        if (!CollectionUtils.isEmpty(values2)) {
            params2.put(key2, (values2 = values2.stream().map(value2 -> {
                Object object;
                if (value2 instanceof FormFieldPart) {
                    FormFieldPart formFieldPart = (FormFieldPart)value2;
                    object = formFieldPart.value();
                } else {
                    object = value2;
                }
                return object;
            }).toList()).size() == 1 ? values2.get(0) : values2);
        }
    }

    private record MapValueResolver(Map<String, Object> map) implements DataBinder.ValueResolver
    {
        @Override
        @Nullable
        public Object resolveValue(String name2, Class<?> type2) {
            return this.map.get(name2);
        }

        @Override
        public Set<String> getNames() {
            return this.map.keySet();
        }
    }
}

