/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import jakarta.validation.Validator;
import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.validation.DataBinder;
import org.springframework.validation.SmartValidator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.BindParamNameResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.bind.support.WebRequestDataBinder;
import org.springframework.web.context.request.NativeWebRequest;

public class DefaultDataBinderFactory
implements WebDataBinderFactory {
    @Nullable
    private final WebBindingInitializer initializer;
    private boolean methodValidationApplicable;

    public DefaultDataBinderFactory(@Nullable WebBindingInitializer initializer) {
        this.initializer = initializer;
    }

    public void setMethodValidationApplicable(boolean methodValidationApplicable) {
        this.methodValidationApplicable = methodValidationApplicable;
    }

    @Override
    public final WebDataBinder createBinder(NativeWebRequest webRequest, @Nullable Object target2, String objectName) throws Exception {
        return this.createBinderInternal(webRequest, target2, objectName, null);
    }

    @Override
    public final WebDataBinder createBinder(NativeWebRequest webRequest, @Nullable Object target2, String objectName, ResolvableType type2) throws Exception {
        return this.createBinderInternal(webRequest, target2, objectName, type2);
    }

    private WebDataBinder createBinderInternal(NativeWebRequest webRequest, @Nullable Object target2, String objectName, @Nullable ResolvableType type2) throws Exception {
        Object object;
        WebDataBinder dataBinder = this.createBinderInstance(target2, objectName, webRequest);
        dataBinder.setNameResolver(new BindParamNameResolver());
        if (target2 == null && type2 != null) {
            dataBinder.setTargetType(type2);
        }
        if (this.initializer != null) {
            this.initializer.initBinder(dataBinder);
        }
        this.initBinder(dataBinder, webRequest);
        if (this.methodValidationApplicable && type2 != null && (object = type2.getSource()) instanceof MethodParameter) {
            MethodParameter parameter = (MethodParameter)object;
            MethodValidationInitializer.initBinder(dataBinder, parameter);
        }
        return dataBinder;
    }

    protected WebDataBinder createBinderInstance(@Nullable Object target2, String objectName, NativeWebRequest webRequest) throws Exception {
        return new WebRequestDataBinder(target2, objectName);
    }

    protected void initBinder(WebDataBinder dataBinder, NativeWebRequest webRequest) throws Exception {
    }

    private static class MethodValidationInitializer {
        private MethodValidationInitializer() {
        }

        public static void initBinder(DataBinder binder, MethodParameter parameter) {
            for (Annotation annotation : parameter.getParameterAnnotations()) {
                if (!annotation.annotationType().getName().equals("jakarta.validation.Valid")) continue;
                binder.setExcludedValidators(v -> {
                    SmartValidator sv;
                    return v instanceof Validator || v instanceof SmartValidator && (sv = (SmartValidator)v).unwrap(Validator.class) != null;
                });
            }
        }
    }
}

