/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.core.CollectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.MultipartFile;

public class WebDataBinder
extends DataBinder {
    public static final String DEFAULT_FIELD_MARKER_PREFIX = "_";
    public static final String DEFAULT_FIELD_DEFAULT_PREFIX = "!";
    @Nullable
    private String fieldMarkerPrefix = "_";
    @Nullable
    private String fieldDefaultPrefix = "!";
    private boolean bindEmptyMultipartFiles = true;

    public WebDataBinder(@Nullable Object target2) {
        super(target2);
    }

    public WebDataBinder(@Nullable Object target2, String objectName) {
        super(target2, objectName);
    }

    public void setFieldMarkerPrefix(@Nullable String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    @Nullable
    public String getFieldMarkerPrefix() {
        return this.fieldMarkerPrefix;
    }

    public void setFieldDefaultPrefix(@Nullable String fieldDefaultPrefix) {
        this.fieldDefaultPrefix = fieldDefaultPrefix;
    }

    @Nullable
    public String getFieldDefaultPrefix() {
        return this.fieldDefaultPrefix;
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public boolean isBindEmptyMultipartFiles() {
        return this.bindEmptyMultipartFiles;
    }

    @Nullable
    protected Object resolvePrefixValue(String name2, Class<?> type2, BiFunction<String, Class<?>, Object> resolver) {
        Object value2 = resolver.apply(name2, type2);
        if (value2 == null) {
            String prefix = this.getFieldDefaultPrefix();
            if (prefix != null) {
                value2 = resolver.apply(prefix + name2, type2);
            }
            if (value2 == null && (prefix = this.getFieldMarkerPrefix()) != null && resolver.apply(prefix + name2, type2) != null) {
                value2 = this.getEmptyValue(type2);
            }
        }
        return value2;
    }

    @Override
    protected void doBind(MutablePropertyValues mpvs) {
        this.checkFieldDefaults(mpvs);
        this.checkFieldMarkers(mpvs);
        this.adaptEmptyArrayIndices(mpvs);
        super.doBind(mpvs);
    }

    protected void checkFieldDefaults(MutablePropertyValues mpvs) {
        String fieldDefaultPrefix = this.getFieldDefaultPrefix();
        if (fieldDefaultPrefix != null) {
            PropertyValue[] pvArray;
            for (PropertyValue pv : pvArray = mpvs.getPropertyValues()) {
                if (!pv.getName().startsWith(fieldDefaultPrefix)) continue;
                String field = pv.getName().substring(fieldDefaultPrefix.length());
                if (this.getPropertyAccessor().isWritableProperty(field) && !mpvs.contains(field)) {
                    mpvs.add(field, pv.getValue());
                }
                mpvs.removePropertyValue(pv);
            }
        }
    }

    protected void checkFieldMarkers(MutablePropertyValues mpvs) {
        String fieldMarkerPrefix = this.getFieldMarkerPrefix();
        if (fieldMarkerPrefix != null) {
            PropertyValue[] pvArray;
            for (PropertyValue pv : pvArray = mpvs.getPropertyValues()) {
                if (!pv.getName().startsWith(fieldMarkerPrefix)) continue;
                String field = pv.getName().substring(fieldMarkerPrefix.length());
                if (this.getPropertyAccessor().isWritableProperty(field) && !mpvs.contains(field)) {
                    Class<?> fieldType = this.getPropertyAccessor().getPropertyType(field);
                    mpvs.add(field, this.getEmptyValue(field, fieldType));
                }
                mpvs.removePropertyValue(pv);
            }
        }
    }

    protected void adaptEmptyArrayIndices(MutablePropertyValues mpvs) {
        for (PropertyValue pv : mpvs.getPropertyValues()) {
            String name2 = pv.getName();
            if (!name2.endsWith("[]")) continue;
            String field = name2.substring(0, name2.length() - 2);
            if (this.getPropertyAccessor().isWritableProperty(field) && !mpvs.contains(field)) {
                mpvs.add(field, pv.getValue());
            }
            mpvs.removePropertyValue(pv);
        }
    }

    @Nullable
    protected Object getEmptyValue(String field, @Nullable Class<?> fieldType) {
        return fieldType != null ? this.getEmptyValue(fieldType) : null;
    }

    @Nullable
    public Object getEmptyValue(Class<?> fieldType) {
        block6: {
            try {
                if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                    return Boolean.FALSE;
                }
                if (fieldType.isArray()) {
                    return Array.newInstance(fieldType.componentType(), 0);
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    return CollectionFactory.createCollection(fieldType, 0);
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    return CollectionFactory.createMap(fieldType, 0);
                }
            }
            catch (IllegalArgumentException ex) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Failed to create default value - falling back to null: " + ex.getMessage());
            }
        }
        return null;
    }

    protected void bindMultipart(Map<String, List<MultipartFile>> multipartFiles, MutablePropertyValues mpvs) {
        multipartFiles.forEach((key2, values2) -> {
            if (values2.size() == 1) {
                MultipartFile value2 = (MultipartFile)values2.get(0);
                if (this.isBindEmptyMultipartFiles() || !value2.isEmpty()) {
                    mpvs.add((String)key2, value2);
                }
            } else {
                mpvs.add((String)key2, values2);
            }
        });
    }
}

