/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import jakarta.servlet.ServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;

public abstract class ServletRequestUtils {
    private static final IntParser INT_PARSER = new IntParser();
    private static final LongParser LONG_PARSER = new LongParser();
    private static final FloatParser FLOAT_PARSER = new FloatParser();
    private static final DoubleParser DOUBLE_PARSER = new DoubleParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final StringParser STRING_PARSER = new StringParser();

    @Nullable
    public static Integer getIntParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        if (request.getParameter(name2) == null) {
            return null;
        }
        return ServletRequestUtils.getRequiredIntParameter(request, name2);
    }

    public static int getIntParameter(ServletRequest request, String name2, int defaultVal) {
        if (request.getParameter(name2) == null) {
            return defaultVal;
        }
        try {
            return ServletRequestUtils.getRequiredIntParameter(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static int[] getIntParameters(ServletRequest request, String name2) {
        try {
            return ServletRequestUtils.getRequiredIntParameters(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return new int[0];
        }
    }

    public static int getRequiredIntParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        return INT_PARSER.parseInt(name2, request.getParameter(name2));
    }

    public static int[] getRequiredIntParameters(ServletRequest request, String name2) throws ServletRequestBindingException {
        return INT_PARSER.parseInts(name2, request.getParameterValues(name2));
    }

    @Nullable
    public static Long getLongParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        if (request.getParameter(name2) == null) {
            return null;
        }
        return ServletRequestUtils.getRequiredLongParameter(request, name2);
    }

    public static long getLongParameter(ServletRequest request, String name2, long defaultVal) {
        if (request.getParameter(name2) == null) {
            return defaultVal;
        }
        try {
            return ServletRequestUtils.getRequiredLongParameter(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static long[] getLongParameters(ServletRequest request, String name2) {
        try {
            return ServletRequestUtils.getRequiredLongParameters(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return new long[0];
        }
    }

    public static long getRequiredLongParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        return LONG_PARSER.parseLong(name2, request.getParameter(name2));
    }

    public static long[] getRequiredLongParameters(ServletRequest request, String name2) throws ServletRequestBindingException {
        return LONG_PARSER.parseLongs(name2, request.getParameterValues(name2));
    }

    @Nullable
    public static Float getFloatParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        if (request.getParameter(name2) == null) {
            return null;
        }
        return Float.valueOf(ServletRequestUtils.getRequiredFloatParameter(request, name2));
    }

    public static float getFloatParameter(ServletRequest request, String name2, float defaultVal) {
        if (request.getParameter(name2) == null) {
            return defaultVal;
        }
        try {
            return ServletRequestUtils.getRequiredFloatParameter(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static float[] getFloatParameters(ServletRequest request, String name2) {
        try {
            return ServletRequestUtils.getRequiredFloatParameters(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return new float[0];
        }
    }

    public static float getRequiredFloatParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        return FLOAT_PARSER.parseFloat(name2, request.getParameter(name2));
    }

    public static float[] getRequiredFloatParameters(ServletRequest request, String name2) throws ServletRequestBindingException {
        return FLOAT_PARSER.parseFloats(name2, request.getParameterValues(name2));
    }

    @Nullable
    public static Double getDoubleParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        if (request.getParameter(name2) == null) {
            return null;
        }
        return ServletRequestUtils.getRequiredDoubleParameter(request, name2);
    }

    public static double getDoubleParameter(ServletRequest request, String name2, double defaultVal) {
        if (request.getParameter(name2) == null) {
            return defaultVal;
        }
        try {
            return ServletRequestUtils.getRequiredDoubleParameter(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static double[] getDoubleParameters(ServletRequest request, String name2) {
        try {
            return ServletRequestUtils.getRequiredDoubleParameters(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return new double[0];
        }
    }

    public static double getRequiredDoubleParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        return DOUBLE_PARSER.parseDouble(name2, request.getParameter(name2));
    }

    public static double[] getRequiredDoubleParameters(ServletRequest request, String name2) throws ServletRequestBindingException {
        return DOUBLE_PARSER.parseDoubles(name2, request.getParameterValues(name2));
    }

    @Nullable
    public static Boolean getBooleanParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        if (request.getParameter(name2) == null) {
            return null;
        }
        return ServletRequestUtils.getRequiredBooleanParameter(request, name2);
    }

    public static boolean getBooleanParameter(ServletRequest request, String name2, boolean defaultVal) {
        if (request.getParameter(name2) == null) {
            return defaultVal;
        }
        try {
            return ServletRequestUtils.getRequiredBooleanParameter(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static boolean[] getBooleanParameters(ServletRequest request, String name2) {
        try {
            return ServletRequestUtils.getRequiredBooleanParameters(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return new boolean[0];
        }
    }

    public static boolean getRequiredBooleanParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        return BOOLEAN_PARSER.parseBoolean(name2, request.getParameter(name2));
    }

    public static boolean[] getRequiredBooleanParameters(ServletRequest request, String name2) throws ServletRequestBindingException {
        return BOOLEAN_PARSER.parseBooleans(name2, request.getParameterValues(name2));
    }

    @Nullable
    public static String getStringParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        if (request.getParameter(name2) == null) {
            return null;
        }
        return ServletRequestUtils.getRequiredStringParameter(request, name2);
    }

    public static String getStringParameter(ServletRequest request, String name2, String defaultVal) {
        String val = request.getParameter(name2);
        return val != null ? val : defaultVal;
    }

    public static String[] getStringParameters(ServletRequest request, String name2) {
        try {
            return ServletRequestUtils.getRequiredStringParameters(request, name2);
        }
        catch (ServletRequestBindingException ex) {
            return new String[0];
        }
    }

    public static String getRequiredStringParameter(ServletRequest request, String name2) throws ServletRequestBindingException {
        return STRING_PARSER.validateRequiredString(name2, request.getParameter(name2));
    }

    public static String[] getRequiredStringParameters(ServletRequest request, String name2) throws ServletRequestBindingException {
        return STRING_PARSER.validateRequiredStrings(name2, request.getParameterValues(name2));
    }

    private static class IntParser
    extends ParameterParser<Integer> {
        private IntParser() {
        }

        @Override
        protected String getType() {
            return "int";
        }

        @Override
        protected Integer doParse(String s2) throws NumberFormatException {
            return Integer.valueOf(s2);
        }

        public int parseInt(String name2, String parameter) throws ServletRequestBindingException {
            return (Integer)this.parse(name2, parameter);
        }

        public int[] parseInts(String name2, String[] values2) throws ServletRequestBindingException {
            this.validateRequiredParameter(name2, values2);
            int[] parameters2 = new int[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                parameters2[i2] = this.parseInt(name2, values2[i2]);
            }
            return parameters2;
        }
    }

    private static class LongParser
    extends ParameterParser<Long> {
        private LongParser() {
        }

        @Override
        protected String getType() {
            return "long";
        }

        @Override
        protected Long doParse(String parameter) throws NumberFormatException {
            return Long.valueOf(parameter);
        }

        public long parseLong(String name2, String parameter) throws ServletRequestBindingException {
            return (Long)this.parse(name2, parameter);
        }

        public long[] parseLongs(String name2, String[] values2) throws ServletRequestBindingException {
            this.validateRequiredParameter(name2, values2);
            long[] parameters2 = new long[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                parameters2[i2] = this.parseLong(name2, values2[i2]);
            }
            return parameters2;
        }
    }

    private static class FloatParser
    extends ParameterParser<Float> {
        private FloatParser() {
        }

        @Override
        protected String getType() {
            return "float";
        }

        @Override
        protected Float doParse(String parameter) throws NumberFormatException {
            return Float.valueOf(parameter);
        }

        public float parseFloat(String name2, String parameter) throws ServletRequestBindingException {
            return ((Float)this.parse(name2, parameter)).floatValue();
        }

        public float[] parseFloats(String name2, String[] values2) throws ServletRequestBindingException {
            this.validateRequiredParameter(name2, values2);
            float[] parameters2 = new float[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                parameters2[i2] = this.parseFloat(name2, values2[i2]);
            }
            return parameters2;
        }
    }

    private static class DoubleParser
    extends ParameterParser<Double> {
        private DoubleParser() {
        }

        @Override
        protected String getType() {
            return "double";
        }

        @Override
        protected Double doParse(String parameter) throws NumberFormatException {
            return Double.valueOf(parameter);
        }

        public double parseDouble(String name2, String parameter) throws ServletRequestBindingException {
            return (Double)this.parse(name2, parameter);
        }

        public double[] parseDoubles(String name2, String[] values2) throws ServletRequestBindingException {
            this.validateRequiredParameter(name2, values2);
            double[] parameters2 = new double[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                parameters2[i2] = this.parseDouble(name2, values2[i2]);
            }
            return parameters2;
        }
    }

    private static class BooleanParser
    extends ParameterParser<Boolean> {
        private BooleanParser() {
        }

        @Override
        protected String getType() {
            return "boolean";
        }

        @Override
        protected Boolean doParse(String parameter) throws NumberFormatException {
            return parameter.equalsIgnoreCase("true") || parameter.equalsIgnoreCase("on") || parameter.equalsIgnoreCase("yes") || parameter.equals("1");
        }

        public boolean parseBoolean(String name2, String parameter) throws ServletRequestBindingException {
            return (Boolean)this.parse(name2, parameter);
        }

        public boolean[] parseBooleans(String name2, String[] values2) throws ServletRequestBindingException {
            this.validateRequiredParameter(name2, values2);
            boolean[] parameters2 = new boolean[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                parameters2[i2] = this.parseBoolean(name2, values2[i2]);
            }
            return parameters2;
        }
    }

    private static class StringParser
    extends ParameterParser<String> {
        private StringParser() {
        }

        @Override
        protected String getType() {
            return "string";
        }

        @Override
        protected String doParse(String parameter) throws NumberFormatException {
            return parameter;
        }

        public String validateRequiredString(String name2, String value2) throws ServletRequestBindingException {
            this.validateRequiredParameter(name2, value2);
            return value2;
        }

        public String[] validateRequiredStrings(String name2, String[] values2) throws ServletRequestBindingException {
            this.validateRequiredParameter(name2, values2);
            for (String value2 : values2) {
                this.validateRequiredParameter(name2, value2);
            }
            return values2;
        }
    }

    private static abstract class ParameterParser<T> {
        private ParameterParser() {
        }

        protected final T parse(String name2, String parameter) throws ServletRequestBindingException {
            this.validateRequiredParameter(name2, parameter);
            try {
                return this.doParse(parameter);
            }
            catch (NumberFormatException ex) {
                throw new ServletRequestBindingException("Required " + this.getType() + " parameter '" + name2 + "' with value of '" + parameter + "' is not a valid number", ex);
            }
        }

        protected final void validateRequiredParameter(String name2, @Nullable Object parameter) throws ServletRequestBindingException {
            if (parameter == null) {
                throw new MissingServletRequestParameterException(name2, this.getType());
            }
        }

        protected abstract String getType();

        protected abstract T doParse(String var1) throws NumberFormatException;
    }
}

