/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.MissingRequestValueException;

public class MissingServletRequestParameterException
extends MissingRequestValueException {
    private final String parameterName;
    private final String parameterType;
    @Nullable
    private final MethodParameter parameter;

    public MissingServletRequestParameterException(String parameterName, String parameterType) {
        super("", false, null, new Object[]{parameterName});
        this.parameterName = parameterName;
        this.parameterType = parameterType;
        this.parameter = null;
        this.getBody().setDetail(MissingServletRequestParameterException.initBodyDetail(this.parameterName));
    }

    public MissingServletRequestParameterException(String parameterName, MethodParameter parameter, boolean missingAfterConversion) {
        super("", missingAfterConversion, null, new Object[]{parameterName});
        this.parameterName = parameterName;
        this.parameterType = parameter.getNestedParameterType().getSimpleName();
        this.parameter = parameter;
        this.getBody().setDetail(MissingServletRequestParameterException.initBodyDetail(this.parameterName));
    }

    @Deprecated(since="6.1", forRemoval=true)
    public MissingServletRequestParameterException(String parameterName, String parameterType, boolean missingAfterConversion) {
        super("", missingAfterConversion, null, new Object[]{parameterName});
        this.parameterName = parameterName;
        this.parameterType = parameterType;
        this.parameter = null;
        this.getBody().setDetail(MissingServletRequestParameterException.initBodyDetail(this.parameterName));
    }

    private static String initBodyDetail(String name2) {
        return "Required parameter '" + name2 + "' is not present.";
    }

    @Override
    public String getMessage() {
        return "Required request parameter '" + this.parameterName + "' for method parameter type " + this.parameterType + " is " + (this.isMissingAfterConversion() ? "present but converted to null" : "not present");
    }

    public final String getParameterName() {
        return this.parameterName;
    }

    public final String getParameterType() {
        return this.parameterType;
    }

    @Nullable
    public MethodParameter getMethodParameter() {
        return this.parameter;
    }
}

